/*
Gamebots Pogamut derivation Copyright (c) 2010-2011, Michal Bida, Radek Pibil

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This software must also be in compliance with the Epic Games Inc. license for mods which states the following: "Your mods must be distributed solely for free, period. Neither you, nor any other person or party, may sell them to anyone, commercially exploit them in any way, or charge anyone for receiving or using them without prior written consent of Epic Games Inc. You may exchange them at no charge among other end-users and distribute them to others over the Internet, on magazine cover disks, or otherwise for free." Please see http://www.epicgames.com/ut2k4_eula.html for more information.

*/
class GBReplicationInfo extends UTPlayerReplicationInfo;

//var PlayerReplicationInfo myPRI;

var vector myLocation;

var vector myVelocity;

var vector myFocus;

var rotator myRotation;

var Pawn myPawn;

var int myHealth;

var bool myPawnIsNone;

var string myFocusName;

var string myLastGBCommand;

var vector CustomRoute[32];

//holds our current center emoticon name
var string myEmoticonCenter;

//center emotcion size 1 - small, 2 - medium, 3 - large
var int myEmoticonCenterSize;

//holds our current left emoticon name
var string myEmoticonLeft;

//left emotcion size 1 - small, 2 - medium, 3 - large
var int myEmoticonLeftSize;

//holds our current right emoticon name
var string myEmoticonRight;

//right emotcion size 1 - small, 2 - medium, 3 - large
var int myEmoticonRightSize;

//emoticon bubble type
var string myEmoticonBubbleType;

//emoticon bubble size
var int myEmoticonBubbleSize;

//horizontal offset of the emoticon
var float myEmoticonOffset;

//the time the emoticon was set
var float currentEmoticonSetTime;

//duration of the emoticon
var float currentEmoticonDuration;

replication
{
	if (ROLE == ROLE_Authority)
		myFocus, myFocusName, myPawn, myHealth, myPawnIsNone, myLocation, myRotation, myVelocity, CustomRoute,
			MyLastGBCommand, myEmoticonCenter, myEmoticonCenterSize, myEmoticonRight, myEmoticonRightSize,
		myEmoticonLeft, myEmoticonLeftSize, myEmoticonBubbleType, myEmoticonBubbleSize, myEmoticonOffset;

}

simulated event PostBeginPlay()
{
	if ( Role < ROLE_Authority )
		return;

	Timer();
	SetTimer(0.02, true);
}

simulated function SetCustomRoute(vector v, int i)
{
	CustomRoute[i] = v;
}

simulated function vector GetCustomRoute(int i)
{
	return CustomRoute[i];
}

simulated function vector GetVelocity()
{
	return myVelocity;
}

simulated function rotator GetRotation()
{
	return myRotation;
}

simulated function vector GetLocation()
{
	return myLocation;
}

simulated function Pawn getMyPawn() {
	return myPawn;
}

simulated function int getMyHealth() {
	return myHealth;
}

simulated function string GetLastGBCommand() {
	return myLastGBCommand;
}

simulated function bool PawnIsNone()
{
	return myPawnIsNone;
}

simulated function vector GetFocus()
{
	return myFocus;
}

simulated function string GetFocusName()
{
	return myFocusName;
}

simulated function SetMyLastGBCommand(string newCmd) {
	myLastGBCommand = newCmd;
}

function UpdatePosition()
{
    local Pawn P;
    local Controller C;

    C = Controller(Owner);

    if( C != None )
        P = C.Pawn;

    if( P == none )
    {
    	myPawnIsNone = true;
		myPawn = none;
        return;
    }
    else
    	myPawnIsNone = false;

	myPawn = P;
	myHealth = P.Health;
	myLocation = P.Location;
	myRotation = P.GetViewRotation();
	myVelocity = P.Velocity;

	if (C.Focus != none)
	{
		myFocusName = string(C.Focus);
		myFocus = C.Focus.Location;

	} else {
		myFocusName = "";
		myFocus = C.GetFocalPoint();
	}

	//updating emoticons
	if (WorldInfo.TimeSeconds > currentEmoticonDuration + currentEmoticonSetTime) {
		myEmoticonCenter = "";
		SetEmoticonCenter("");
		myEmoticonLeft = "";
		SetEmoticonLeft("");
		myEmoticonRight = "";
		SetEmoticonRight("");
	}
}

function Timer()
{
	UpdatePosition();
	SetTimer(0.05, true);
}

/** Emoticons ... */

function SetEmoticonBubbleType(string type)
{
	myEmoticonBubbleType = type;
}

simulated function string GetEmoticonBubbleType()
{
	return myEmoticonBubbleType;
}

function SetEmoticonBubbleSize(int type)
{
	myEmoticonBubbleSize = type;
}

simulated function int GetEmoticonBubbleSize()
{
	return myEmoticonBubbleSize;
}

function SetEmoticonCenter(string text)
{
	myEmoticonCenter = text;
}

simulated function string GetEmoticonCenter()
{
	return myEmoticonCenter;
}

function SetEmoticonCenterSize(int size)
{
	myEmoticonCenterSize = size;
}

simulated function int GetEmoticonCenterSize()
{
	return myEmoticonCenterSize;
}

function SetEmoticonLeft(string text)
{
	myEmoticonLeft = text;
}

simulated function string GetEmoticonLeft()
{
	return myEmoticonLeft;
}

function SetEmoticonLeftSize(int size)
{
	myEmoticonLeftSize = size;
}

simulated function int GetEmoticonLeftSize()
{
	return myEmoticonLeftSize;
}

function SetEmoticonRight(string text)
{
	myEmoticonRight = text;
}

simulated function string GetEmoticonRight()
{
	return myEmoticonRight;
}

function SetEmoticonRightSize(int size)
{
	myEmoticonRightSize = size;
}

simulated function int GetEmoticonRightSize()
{
	return myEmoticonRightSize;
}

simulated function float GetEmoticonOffset()
{
	return myEmoticonOffset;
}

function SetEmoticonOffset(float offset)
{	
	myEmoticonOffset = offset;
}

//time in seconds
function SetEmoticonTime(float time)
{
	currentEmoticonSetTime = WorldInfo.TimeSeconds;
	currentEmoticonDuration = time;
}

defaultproperties
{
	NetUpdateFrequency=50
}

