/*
Gamebots Pogamut derivation Copyright (c) 2010-2011, Michal Bida, Radek Pibil

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This software must also be in compliance with the Epic Games Inc. license for mods which states the following: "Your mods must be distributed solely for free, period. Neither you, nor any other person or party, may sell them to anyone, commercially exploit them in any way, or charge anyone for receiving or using them without prior written consent of Epic Games Inc. You may exchange them at no charge among other end-users and distribute them to others over the Internet, on magazine cover disks, or otherwise for free." Please see http://www.epicgames.com/ut2k4_eula.html for more information.

*/
class RayVisualizer extends Emitter
	placeable;

var vector StartEffect, EndEffect;

//----------

var rotator BeamDirection; //Relative Beam Direction
var float BeamLength; //Beam Length
var bool bFloorCorrection; //if we should adjust ray according to floor normal
var bool bHit;
var bool bLastHitState;

simulated event PostBeginPlay()
{
	ParticleSystemComponent.SetHidden(false);
	//ParticleSystemComponent.SetTemplate(ParticleSystem'WP_LinkGun.Effects.P_WP_Linkgun_Altbeam_Blue');
	ParticleSystemComponent.SetTickGroup( TG_PostUpdateWork );
	ParticleSystemComponent.SetDepthPriorityGroup(SDPG_World);
	ParticleSystemComponent.bUpdateComponentInTick = true;
	ParticleSystemComponent.SetIgnoreOwnerHidden(TRUE);
	ParticleSystemComponent.SetScale(0.5f);

	Super.PostBeginPlay();

}
replication
{
    if (Role == ROLE_Authority)
        StartEffect, EndEffect, BeamDirection, BeamLength, bFloorCorrection, bHit;
}


simulated function SetBeamLocation()
{
	StartEffect = Instigator.Location;
	SetLocation(Instigator.Location);
}


simulated function Vector SetBeamRotation()
{
	local vector  FloorLocation, FloorNormal;
	local vector  RealRayDirection;


	RealRayDirection = vector(Instigator.Rotation + BeamDirection);
	//we have to take into account also angle of the floor we are standing on
	if (bFloorCorrection)
	{
		FloorNormal = vect(0,0,0);
		Trace(FloorLocation,FloorNormal, Instigator.Location + vect(0,0,-100), Instigator.Location, false, ,);

		RealRayDirection += FloorNormal * (RealRayDirection dot FloorNormal) * -1;
	}

	EndEffect = StartEffect + (RealRayDirection * BeamLength);

    SetRotation( Rotator(EndEffect - Location) );

	return Normal(EndEffect - Location);
}

simulated function Tick(float dt)
{	
	// set beam start location, rotation
	if (Instigator != none) { //instigator may not be seen at the moment, so won't be replicated
		SetBeamLocation();
		SetBeamRotation();
		changeRay(bHit);    
		ParticleSystemComponent.SetVectorParameter('LinkBeamEnd', EndEffect);
		//ParticleSystemComponent.SetBeamEndPoint(0, EndEffect);  
    }
}

simulated event Destroyed() {
	//loginternal("RayVisualizer.Destroyed()");	
	super.Destroyed();
}

simulated function changeRay(bool bHit) {
	ParticleSystemComponent.DeactivateSystem();

	if (bHit && !bLastHitState) {				
		ParticleSystemComponent.SetTemplate(ParticleSystem'WP_LinkGun.Effects.P_WP_Linkgun_Altbeam_Red');					
		bLastHitState = true;
	}
	else if (!bHit && bLastHitState) {
		ParticleSystemComponent.SetTemplate(ParticleSystem'WP_LinkGun.Effects.P_WP_Linkgun_Altbeam_Blue');
		bLastHitState = false;
	}
				
	ParticleSystemComponent.ActivateSystem();
}

DefaultProperties
{
	TickGroup=TG_DuringAsyncWork
	bNetInitialRotation=true
	RemoteRole=ROLE_SimulatedProxy

	Begin Object Name=ParticleSystemComponent0
		Template=ParticleSystem'WP_LinkGun.Effects.P_WP_Linkgun_Altbeam_Blue'
	End Object
	ParticleSystemComponent=ParticleSystemComponent0

	bStatic=false
	bNoDelete=false
	bReplicateInstigator=true	
}
