/*
 * Decompiled with CFR 0.152.
 */
package decisionMakingSystem;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import decisionMakingSystem.Affordance;
import decisionMakingSystem.EItem;
import decisionMakingSystem.GlobalParameters;
import decisionMakingSystem.ItemCathegory;
import java.io.Serializable;
import java.util.ArrayList;

public class ItemRecord
implements Comparable,
Serializable {
    public Location location = null;
    public ArrayList<Affordance> affordances = null;
    public ItemCathegory cathegory = null;
    private int missed = 0;
    private int found = 0;
    private int seen = 0;
    private int time = 0;
    public double probability = 0.0;

    public ItemRecord(EItem eItem, int time) {
        switch (eItem.cathegory) {
            case PICKABLE: {
                this.location = eItem.getLocation();
                break;
            }
            case PLACE: {
                this.location = eItem.getLocation();
                break;
            }
            case PLAYER: {
                this.location = eItem.getLocation();
                break;
            }
            default: {
                this.location = new Location();
            }
        }
        this.cathegory = eItem.cathegory;
        this.affordances = eItem.getAffordances();
        this.time = time;
    }

    public String toString() {
        this.updateProbability();
        String result = "item cathegory: " + (Object)((Object)this.cathegory);
        result = result + " location: " + this.location + "\t" + " probability: " + this.probability;
        result = result + "\t f: " + this.found + " s: " + this.seen + " m: " + this.missed;
        result = result + "\t time: " + this.time;
        return result;
    }

    public void seen(int counter) {
        ++this.seen;
        this.time = counter;
    }

    public void found(int counter) {
        ++this.found;
        this.time = counter;
    }

    public void missed(int counter) {
        ++this.missed;
        this.time = counter;
    }

    public void updateProbability() {
        double result = (2 * this.found - this.missed) * 10 + this.seen;
        if (result > 100.0) {
            result = 100.0;
        }
        if (result < 0.0) {
            result = 0.0;
        }
        this.probability = result / 100.0;
    }

    public void updateProbability(int counter) {
        double result = (2 * this.found - this.missed) * 10 + this.seen;
        if ((result -= (double)((counter - this.time) / GlobalParameters.LENGHT_OF_A_DAY * 10)) > 100.0) {
            result = 100.0;
        }
        if (result < 0.0) {
            result = 0.0;
        }
        this.probability = result / 100.0;
    }

    public void updateProbability(int counter, Location location) {
        double result = (2 * this.found - this.missed) * 10 + this.seen;
        result -= (double)((counter - this.time) / GlobalParameters.LENGHT_OF_A_DAY * 10);
        if ((result -= this.location.getDistance(location) / 500.0) > 100.0) {
            result = 100.0;
        }
        if (result < 0.0) {
            result = 0.0;
        }
        this.probability = result / 100.0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ItemRecord other = (ItemRecord)obj;
        return other.location.equals(this.location) && this.affordances.equals(other.affordances) && other.cathegory.equals((Object)this.cathegory);
    }

    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + (this.location != null ? this.location.hashCode() : 0);
        hash = 61 * hash + (this.affordances != null ? this.affordances.hashCode() : 0);
        hash = 61 * hash + (this.cathegory != null ? this.cathegory.hashCode() : 0);
        return hash;
    }

    public void dailyUpdate() {
        this.seen -= 10;
        --this.missed;
        --this.found;
        this.seen = this.seen < 0 ? 0 : this.seen;
        this.found = this.found < 0 ? 0 : this.found;
        this.missed = this.missed < 0 ? 0 : this.missed;
    }

    public int compareTo(Object o) {
        int BEFORE = -1;
        boolean EQUAL = false;
        boolean AFTER = true;
        if (this == o) {
            return 0;
        }
        ItemRecord aThat = (ItemRecord)o;
        if (this.probability < aThat.probability) {
            return -1;
        }
        if (this.probability > aThat.probability) {
            return 1;
        }
        return 0;
    }

    boolean obsolete(int counter) {
        if (this.probability < 0.05) {
            return true;
        }
        return counter - this.time > GlobalParameters.LENGHT_OF_A_DAY;
    }
}

