package utils;

import decisionMakingSystem.GlobalParameters;
import java.text.SimpleDateFormat;
import java.util.Calendar;

/**
 * Provides some methods to transfer counter to day, hours, minutes, date etc.
 * 
 * @author Ondrej Burkert
 */
public final class TimeUtils {

    private static String[] days = {"Mo", "Tu", "We", "Th", "Fr", "Sa", "Su"};

    public static int counterToDays(int counter) {
        return (counter / GlobalParameters.LENGHT_OF_A_DAY) + 1;
    }

    /**
     * day hour - something between 0-24 only int
     * @param counter
     * @return
     */
    public static double counterToHours(int counter) {
        double temp = (counter % GlobalParameters.LENGHT_OF_A_DAY) / (GlobalParameters.LENGHT_OF_A_DAY / 24.0);
        return temp;
    }

    public static boolean isHour(int counter) {
        int tmp = counter % GlobalParameters.LENGHT_OF_A_DAY;
        if (tmp % minutesToTicksOfLogic(60) == 0) {
            return true;
        }
        return false;
    }

    /**
     * returns true if the counter represents exactly to given hour of a day.
     * @param counter
     * @param i
     * @return
     */
    public static boolean isHour(int counter, int i) {
        int tmp = counter % GlobalParameters.LENGHT_OF_A_DAY;
        if (tmp % minutesToTicksOfLogic(60) == 0 && tmp / minutesToTicksOfLogic(60) == i) {
            return true;
        }
        return false;
    }

    /**
     * returns true if the counter represents exactly to given day.
     * @param counter
     * @param i
     * @return
     */
    public static boolean isDay(int counter, int i) {
        int tmp = counter % GlobalParameters.LENGHT_OF_A_DAY;
        if (tmp == 0 && counter / GlobalParameters.LENGHT_OF_A_DAY == i) {
            return true;
        }
        return false;
    }

    public static int minutesToTicksOfLogic(double minutes) {
        long result = Math.round((GlobalParameters.LENGHT_OF_A_DAY / 1440.0) * minutes);
        return (int) result;
    }

    public static String counterToDate(int counter) {
        int day, hour, minutes;
        String result = "";
        day = counterToDays(counter) - 1;
        hour = (int) counterToHours(counter);
        minutes = (counter % hourInTicksOfLogic()) * 60 / hourInTicksOfLogic();
        result = days[day % 7] + ", " + (hour < 10 ? "0" : "") + hour + ":";
        result += (minutes < 10 ? "0" : "") + minutes + ", day " + day + ".";
        return result;
    }

    public static int hourInTicksOfLogic() {
        return (int) Math.round(GlobalParameters.LENGHT_OF_A_DAY / 24.0);
    }

    public static String counterToTime(int counter) {
        int day = counter / GlobalParameters.LENGHT_OF_A_DAY;
        int hour = (int) counterToHours(counter);
        int minutes = (counter % GlobalParameters.LENGHT_OF_A_DAY) % TimeUtils.minutesToTicksOfLogic(60);
        minutes = counterToMinutes(minutes);
        return day + "d " + hour + "h " + minutes + "m.";
    }

    private static int counterToMinutes(int counter) {
        return (counter / (GlobalParameters.LENGHT_OF_A_DAY / 1440));
    }

    /**
     * Gets current system time according to the input dateFormat.
     *
     * @param dateFormat input dateFormat
     * @return current date, time
     */
    public static String now(String dateFormat) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        return sdf.format(cal.getTime());
    }

    /**
     * Returns system time in miliseconds.
     *
     * @return current time in ms
     */
    public static long getTimeInMilis() {
        Calendar cal = Calendar.getInstance();
        return cal.getTimeInMillis();
    }
}
