package scheduler;

import decisionMakingSystem.Action;
import decisionMakingSystem.GlobalParameters;
import decisionMakingSystem.Intention;
import decisionMakingSystem.IntentionStates;
import decisionMakingSystem.Scheduler;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import utils.Interval;
import utils.TimeUtils;

/**
 *
 * @author kadlr3am
 */
public class ProbabilisticScheduler extends Scheduler {

    /** When scheduling one day */
    private ArrayList<Intention> previousPlannedIntentions = new ArrayList<Intention>();
    private ArrayList<Intention> currentPlannedIntentions = new ArrayList<Intention>();
    /** When scheduling one intention, we will remember here the last intention we scheduled */
    private Intention previousPlannedIntention = null;
    private transient DefaultProbability transitions = null;

    public ProbabilisticScheduler(ArrayList<Intention> intentions, Logger log, String directory, String planningFilename) {

        super();
        //Copy from Scheduler class constructor - due to loading of planning file
        this.allIntentions = intentions;
        // initialize name to intention
        this.nameToIntention = new HashMap<String, Intention>();
        for (Intention intention : intentions) {
            nameToIntention.put(intention.getName(), intention);
        }
        this.log = log;
        freePartsOfTheDay = new ArrayList<Boolean>();
        freeTime = new ArrayList<Interval>();
        daySchedule = new ArrayList<Intention>();
        // load XML file planning.xml
        //activityScheduling = loadPlanning(directory, planningFilename);
        // extraScheduling = loadPlanning(directory, "ExtraActivities.xml");
        rnd = new Random(System.currentTimeMillis());

        //Here we construct our transitions
        transitions = new DefaultProbability(directory, planningFilename);
    }

    @Override
    public ArrayList<Intention> scheduleNewDay(int counter) {

        for (Intention intention : nameToIntention.values()) // reinitialize the activation intervals
        {
            intention.setActivationIntervals(null);
        }

        Intention lastPreviousIntention = null;

        if (!previousPlannedIntentions.isEmpty()) {
            lastPreviousIntention = previousPlannedIntentions.get(previousPlannedIntentions.size() - 1);
        } else {
            lastPreviousIntention = new Intention();
            lastPreviousIntention.setName("ISleep");
            ArrayList<Interval> newIntervals = new ArrayList<Interval>();
            newIntervals.add(new Interval(0, counter, 0));
            lastPreviousIntention.setActivationIntervals(newIntervals);
        }

        currentPlannedIntentions = new ArrayList<Intention>();

        scheduleBasicActions(counter);

        /*
        int myCounter = counter;
        int border = counter + GlobalParameters.LENGHT_OF_A_DAY;
        for (; myCounter < border;) {

        IState nextState = transitions.computeNextState(TimeUtils.counterToHours(myCounter), new State(lastPreviousIntention.getName()));

        Intention intent = this.nameToIntention.get(nextState.getItention());

        if (intent.getActivationIntervals() == null) {
        intent.setActivationIntervals(new ArrayList<Interval>());
        }

        intent.getActivationIntervals().add(new Interval(myCounter, myCounter + TimeUtils.minutesToTicksOfLogic(60), getActivation(intent)));
        intent.setDuration(TimeUtils.minutesToTicksOfLogic(60));

        if (!currentPlannedIntentions.contains(intent)) {
        currentPlannedIntentions.add(intent);
        }

        lastPreviousIntention = intent;
        Interval lastInterv = lastPreviousIntention.getActivationIntervals().get(lastPreviousIntention.getActivationIntervals().size() - 1);
        if (lastInterv != null) {
        myCounter = lastInterv.getRightSide();
        } else {
        myCounter = myCounter + TimeUtils.minutesToTicksOfLogic(60);
        }

        }*/

        previousPlannedIntentions = currentPlannedIntentions;
        return currentPlannedIntentions;
    }

    /**
     * Schedules one new intention.
     * 
     * @param counter
     * @return
     */
    public ArrayList<Intention> scheduleNewIntention(int counter) {

        if (previousPlannedIntention == null) {
            previousPlannedIntention = new Intention();
            previousPlannedIntention.setName("Default");
            ArrayList<Interval> newIntervals = new ArrayList<Interval>();
            newIntervals.add(new Interval(0, counter, 0));
            previousPlannedIntention.setActivationIntervals(newIntervals);
        }

        int day = (TimeUtils.counterToDays(counter) - 1) % 7 + 1;
        IState nextState = transitions.computeNextState(TimeUtils.counterToHours(counter), day, new State(previousPlannedIntention.getName()));

    //    System.out.printf("%s", nextState.getItention());
        Intention intent = this.nameToIntention.get(nextState.getItention());


        intent.setActivationIntervals(new ArrayList<Interval>());

        intent.getActivationIntervals().add(new Interval(counter - 1, counter + TimeUtils.minutesToTicksOfLogic(60), getActivation(intent)));
        intent.setDuration(TimeUtils.minutesToTicksOfLogic(60));
        intent.setEnabled(true);
        //intent.setRealized(IntentionStates.NO);
        //intent.setActivity(getActivation(intent));

        if (!currentPlannedIntentions.contains(intent)) {
            currentPlannedIntentions.add(intent);
        }

        previousPlannedIntention = intent;

        return currentPlannedIntentions;
    }

    /**
     * schedules basic actions like sleeping, eating, brushing teeth
     */
    private void scheduleBasicActions(int start) {

        // ask biorythms for the time of the waking up => should reflect, when he went to bed, if it is saturday, etc.
        int dayBegins = start - (int) (Math.floor(start % GlobalParameters.LENGHT_OF_A_DAY));
        // start + TimeUtils.minutesToTicksOfLogic(agentsAlarm + rnd.nextInt(40)); // 7 a.m. it will be soon given by biorythms
        int dayEnds = dayBegins + GlobalParameters.LENGHT_OF_A_DAY;

        int wakeUpTime = (int) Math.round(GlobalParameters.LENGHT_OF_A_DAY / 3.3);
        // start + TimeUtils.minutesToTicksOfLogic(1400 + rnd.nextInt(40)); // 11 p.m. should be determined by biorythms as well

        Intention greet, eat, hygiene;
        //sleep = nameToIntention.get("ISleep");
        greet = nameToIntention.get("ISayHello");
  //      eat = nameToIntention.get("IEat");
  //      hygiene = nameToIntention.get("IHygiene");


        ArrayList<Interval> activationIntervals = new ArrayList<Interval>();
        activationIntervals.add(new Interval(dayBegins, dayEnds, 30));
        greet.setActivationIntervals(activationIntervals);
//    activationIntervals.add(new Interval(dayEnds, start + GlobalParameters.LENGHT_OF_A_DAY, 30));
        //sleep.setActivationIntervals(activationIntervals);
        // hygiene - dayBegins + 15 minutes, dayEnd - 35 minutes
        activationIntervals = new ArrayList<Interval>();
        int randNumber = rnd.nextInt(40);
        activationIntervals.add(new Interval(dayBegins + wakeUpTime + TimeUtils.minutesToTicksOfLogic(5 + randNumber), dayBegins + wakeUpTime + TimeUtils.minutesToTicksOfLogic(20 + randNumber), 80));
        randNumber = rnd.nextInt(40);
        activationIntervals.add(new Interval(dayEnds - TimeUtils.minutesToTicksOfLogic(45 + randNumber), dayEnds - TimeUtils.minutesToTicksOfLogic(30 + randNumber), 80));
//        hygiene.setActivationIntervals(activationIntervals);
        // eating - about 20 minutes breakfast, 40 minutes lunch, dinner
        activationIntervals = new ArrayList<Interval>();
        randNumber = rnd.nextInt(40);
        activationIntervals.add(new Interval(dayBegins + wakeUpTime + TimeUtils.minutesToTicksOfLogic(20 + randNumber), dayBegins + wakeUpTime + TimeUtils.minutesToTicksOfLogic(40 + randNumber), 80)); // breakfast

        int timeOfLunch = dayBegins + GlobalParameters.LENGHT_OF_A_DAY / 2 + TimeUtils.minutesToTicksOfLogic(rnd.nextInt(60) - 30);
        activationIntervals.add(new Interval(timeOfLunch, timeOfLunch + TimeUtils.minutesToTicksOfLogic(40), 60)); // lunch

        int timeOfDinner = dayBegins + GlobalParameters.LENGHT_OF_A_DAY / 2 + GlobalParameters.LENGHT_OF_A_DAY / 4 + TimeUtils.minutesToTicksOfLogic(rnd.nextInt(60) - 90);
        activationIntervals.add(new Interval(timeOfDinner, timeOfDinner + TimeUtils.minutesToTicksOfLogic(40), 80)); // dinner
//        eat.setActivationIntervals(activationIntervals);


        // add those three intentions to the day schedule
        //currentPlannedIntentions.add(sleep);
        //currentPlannedIntentions.add(eat);
        //currentPlannedIntentions.add(hygiene);
        //currentPlannedIntentions.add(greet);
        //log.config("after BASIC ACTION: \n" + printIntentions(daySchedule));
    }

    /**
     * Creates an intention.
     *
     * @param intervals
     * @param activity
     * @param duration
     * @param state
     * @return
     */
    public Intention createIntention(ArrayList<Interval> intervals, int activity, int duration, IState state) {
        Intention result = new Intention();

        result.setActivationIntervals(intervals);
        result.setActivity(activity);
        result.setDuration(duration);
        result.setMemoryDuration(300);
        result.setRealized(IntentionStates.NO);
        result.setActions(new ArrayList<Action>());
        result.setName(state.getItention());

        return result;
    }

    @Override
    public void changeLifestyle(String directory, String planningFilename, int alarm) {
        //super.changeLifestyle(directory, planningFilename, alarm);
    }

    private int getActivation(Intention intent) {
        if (intent.getName().contains("Work")) {
            return 70;
        } else if (intent.getName().contains("Sleep")) {
            return 50;
        } else {
            return 60;
        }
    }
}
