/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package pogamutEndEvent;

import atomicActions.AtomicAction;
import decisionMakingSystem.Action;
import decisionMakingSystem.Intention;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 *
 * @author Miso
 */
public class PogamutEndEventSource implements Serializable {
  private transient List _listeners = new ArrayList();
  public synchronized void addEventListener(IPogamutEndEventListener listener)	{
    _listeners.add(listener);
  }
  public synchronized void removeEventListener(IPogamutEndEventListener listener)	{
    _listeners.remove(listener);
  }

  // call this method whenever you want to notify
  //the event listeners of the particular event
  public synchronized void fireEvent(PogamutEndEventType type, Action act)	{
    PogamutEndEvent event = new PogamutEndEvent(this, type, act);
    Iterator i = _listeners.iterator();
    while(i.hasNext())	{
      ((IPogamutEndEventListener) i.next()).handlePogamutEndEvent(event);
    }
  }
  public synchronized void fireEvent(PogamutEndEventType type, AtomicAction act)	{
    PogamutEndEvent event = new PogamutEndEvent(this, type, act);
    Iterator i = _listeners.iterator();
    while(i.hasNext())	{
      ((IPogamutEndEventListener) i.next()).handlePogamutEndEvent(event);
    }
  }
  public synchronized void fireEvent(PogamutEndEventType type, ArrayList<Intention> intentions)	{
    PogamutEndEvent event = new PogamutEndEvent(this, type, intentions);
    Iterator i = _listeners.iterator();
    while(i.hasNext())	{
      ((IPogamutEndEventListener) i.next()).handlePogamutEndEvent(event);
    }
  }
  public synchronized void fireEvent(PogamutEndEventType type, Intention intention)	{
    PogamutEndEvent event = new PogamutEndEvent(this, type, intention);
    Iterator i = _listeners.iterator();
    while(i.hasNext())	{
      ((IPogamutEndEventListener) i.next()).handlePogamutEndEvent(event);
    }
  }
}
