package pogamutEndEvent;

import atomicActions.AtomicAction;
import decisionMakingSystem.Action;
import decisionMakingSystem.AffordanceType;
import decisionMakingSystem.EItem;
import decisionMakingSystem.Intention;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventObject;

/**
 *
 * @author Miso
 */
public class PogamutEndEvent extends EventObject implements Serializable {

//    private static final long serialVersionUID = 2896860297799632837L;

    public String action;
 //   public AtomicAction atomicAct;
    public PogamutEndEventType type;
    public int counter;
    public ArrayList<Intention> intentionArea;
    public ArrayList<String> intentionAreaS;
    public String intention;
    public int time = 0;
    public ArrayList<String> trace;
    public String atomic;
    public ArrayList<PogamutEndAffordanceUsed> affordances;


    public PogamutEndEvent(Object source, PogamutEndEventType _type, Action _act) {
        super(source);
        action = _act.name;
        trace = new ArrayList<String>();
        Action parentAction = _act;
        Intention parentIntention;
        while (parentAction!= null) {
            trace.add(parentAction.name);
            parentIntention = parentAction.intention;
            if (parentIntention == null) break;
            trace.add(parentIntention.getName());
            parentAction = parentIntention.getAncestorAction();
        }

        commonInit(_type);
    }
    public PogamutEndEvent(Object source, PogamutEndEventType _type, AtomicAction _act) {
        super(source);
//        atomicAct = _act;
        if (_act.dModule != null) {
            time = _act.dModule.counter;
        }

        atomic = _act.type.name();
        trace = new ArrayList<String>();
        affordances = new ArrayList<PogamutEndAffordanceUsed>();
        Action parentAction = _act.parent;
        Intention parentIntention;
        while (parentAction!= null) {
            for (AffordanceType aff : parentAction.satisfyingItems.keySet()) {
                EItem item = parentAction.satisfyingItems.get(aff);
                if (item == null) {
                    affordances.add(new PogamutEndAffordanceUsed(parentAction.name, aff.name(), null));
                } else {
                    affordances.add(new PogamutEndAffordanceUsed(parentAction.name, aff.name(), item.getName()));
                }
            }
            if (_act.agent != null) {
               for (EItem item : _act.agent.getDecisions().perceptiveField.perceivedItems) {
                   affordances.add(new PogamutEndAffordanceUsed(parentAction.name, "perceived", item.getName()));
               }
            }

            parentIntention = parentAction.intention;
            trace.add(parentAction.name);
            if (parentIntention == null) break;
            trace.add(parentIntention.getName());
            parentAction = parentIntention.getAncestorAction();
        }
        commonInit(_type);
    }
    public PogamutEndEvent(Object source, PogamutEndEventType _type, ArrayList<Intention> _intentionArea) {
        super(source);
        intentionAreaS = new ArrayList<String>();
        intentionArea = _intentionArea;
        for (Intention i : intentionArea) {
            intentionAreaS.add(i.getName());
        }
        if (_type == PogamutEndEventType.INTENTION_AREA) {
            //this will only be used for initialization of decision trees
            //string version of intention area is used instead
            intentionArea = null;
        }
        commonInit(_type);
    }
    public PogamutEndEvent(Object source, PogamutEndEventType _type, Intention _intention) {
        super(source);
        intention = _intention.getName();
        trace = new ArrayList<String>();
        Action parentAction;
        Intention parentIntention = _intention;
        while (parentIntention!= null) {
            trace.add(parentIntention.getName());
            parentAction = parentIntention.getAncestorAction();
            if (parentAction == null) break;
            trace.add(parentAction.name);
            parentIntention = parentAction.intention;
        }
        commonInit(_type);
    }

    private void commonInit(PogamutEndEventType _type) {
        type = _type;
    }
}
