package decisionMakingSystem;

import java.io.Serializable;
import java.util.ArrayList;
/**
 * dynamicaly created intention responsible for acquiring things that satisfies 
 * not already satisfied affordances
 * @author Ondrej
 */
public class Want extends Intention implements Serializable {
    // index of internal actions - the action selection is different from general Intention
    private int indexOfActions = 0;
    
    public Want(AffordanceType aff, Action action, DecisionModuleImpl module) {
        super();
        this.setName("_Want " + aff);
        ArrayList<Action> actions = new ArrayList<Action>();
        Action a = null;
        a = new SearchPocket(aff, module, this);
        actions.add(a);
        a = new SearchEnvironment(aff, module, this);
        actions.add(a);
        a = new SearchMemory(aff, module, this);
        actions.add(a);
        a = new SearchRandom(aff, module, this);
        actions.add(a);
        this.setRealized(IntentionStates.NO);

        this.setActions(actions);
        
        this.setAncestorAction(action); 
        
        this.setActivity(action.activity + 5); // and maybe some more - but this is essential for it to be choosen
        
    }
   
    /**
     * a bit different chooseAction - chooses sequentialy in the order: environment, pocket, memory, random
     * @param field
     */
    @Override
    public Action chooseAction() {
        if (this.getRealized().equals(IntentionStates.FAILED))
            return null;
            
        if (this.getChosenAction() == null) { // pick next
            if (this.indexOfActions < this.getActions().size()) {
                this.setChosenAction(this.getActions().get(indexOfActions));
                this.getChosenAction().intention = this;
                indexOfActions += 1;
            } else {
                this.setChosenAction(null);
            }
        }
        return this.getChosenAction();
    }
}