package decisionMakingSystem;

import atomicActions.*;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import java.util.ArrayList;
import java.util.HashMap;


/**
 * search pocket, maybe not even necessary - but we will see
 * @author Ondrej
 */
class AtomicSearchPocket extends AtomicAction {
    DecisionModuleImpl module;
    public AtomicSearchPocket (Action parent, DecisionModuleImpl module) {
        super();
        this.parent = parent;
        this.agent = module.agent;
       // super(parent, module.agent);
        this.module = module;
        this.type = AtomicActions.SEARCH_POCKET;
        dModule = module;
    }
    
    @Override
    public void execute() {
        //this.agent.getAct().act(new Configuration().setAction(this.type.toString()).setName(this.type.toString()));
        this.counter = agent.getCurrentTime();
    }
    
    @Override
    public boolean succeeded() {
        AffordanceType aff = ((SearchPocket)parent).affordance;
        // querry on inventory
        EItem item = module.inventory.getItemOfAffordance(aff);
        if (item != null) {
            // it should go without any testing as intention is forcefully Want and it has to have an ancestor action
            this.module.perceptiveField.satisfyAffordance(this.parent.intention.getAncestorAction(), aff, item);
            agent.getLog().info("Atomic search pocket - " + aff + " - finished. Duration :" + counter + " rounds.");
            return true;
        }
        return false;
    }
    
    @Override
    public boolean failed() {
        if ((counter - actionStart) > parent.timeLimit) {
            return true;
        }
        return false;
    }
    
}
class SearchPocket extends Action {
    protected AffordanceType affordance = null; // easier to querry
    
    public SearchPocket (AffordanceType affordance, DecisionModuleImpl module, Intention intention) {
        super();
        this.satisfyingItems.put(affordance, null);
        this.affordance = affordance; // I double the variable as it is more handy to access it like this
        this.atomicActions = new ArrayList<AtomicAction>();
        this.atomicActions.add(new AtomicSearchPocket(this, module));
        this.name = "_Search Pocket";
        this.timeLimit = 0; // executes just once
        this.state = ActionStates.PRESTATE;
        this.activity = intention.getActivity();
        this.intention = intention; // link to want:)
    }
    
    
}