package decisionMakingSystem;

import bot.*;
import atomicActions.*;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Rotate;
import java.util.ArrayList;
import java.util.HashMap;

/**
 * search environment for thing with affordace - means just to look around
 * and make an effort -> call seeingItem();
 * @author Ondrej
 */
class AtomicSearchEnvironment extends AtomicAction {

    private DecisionModuleImpl module;

    public AtomicSearchEnvironment(Action parent, DecisionModuleImpl module) {
        super();
        this.parent = parent;
        this.agent = module.agent;
    //    super(parent, module.agent);
        this.module = module;
        this.type = AtomicActions.SEARCH_ENVIRONMENT;
        dModule = module;
    }
    /** found item */
    private EItem item = null;
    /** searched affordance */
    private AffordanceType affType = null;

    @Override
    public void execute() {
        if (counter == 0) {
            initialisation();
        }
        this.counter = agent.getCurrentTime();
        
        item = this.module.perceptiveField.getPerceivedItemOfAffordance(affType); // if sees it already
        if (item == null) {
            // doesn't see anything => look around
            item = this.module.things.seeingItem(affType); // or spots it
            //this.agent.getBody().turnHorizontal(50);
            this.agent.getAct().act(new Rotate().setAmount(20000));
        } else {
            if (item.getLocation() != null) {
                this.agent.safeRunToLocation(item.getLocation()); // run to it
                return;
            }
        }
    }

    @Override
    public boolean succeeded() {
        Action parentAction = this.parent.intention.getAncestorAction(); // link to the action which called Want
        // has picked up an item
        if (this.module.inventory.hasItemOfAffordance(affType)) {
            item = this.module.inventory.getItemOfAffordance(affType); // item from inventory
            this.module.perceptiveField.satisfyAffordance(parentAction, affType, item);
            agent.getLog().info("Atomic search environment - " + this.affType + " - finished. Duration :" + counter + " rounds.");
            return true;
        }
        // no hint of an item
        if (item == null || item.cathegory == null) {
            return false;
        }
        boolean succeeded = false;
        switch (item.cathegory) {
            case PLAYER: // see player -> satisfy the affordance
                succeeded = true;
                break;
            case PLACE:
                // place and agent got close enought to it
                if (agent.getLocation() != null) {
                    if (agent.getLocation().getDistance(item.getLocation()) < PLACE_MIN_DIST) {
                        succeeded = true;
                        break;
                    }
                }
                break;
        }
        if (succeeded) {
            item.decreaseAttractivity();
            this.module.perceptiveField.satisfyAffordance(parentAction, affType, item);
            agent.getLog().info("Atomic search environment - " + this.affType + " - finished. Duration :" + counter + " rounds.");
        }
        return succeeded;
    }

    protected static final int PLACE_MIN_DIST = 180;

    @Override
    public boolean failed() {
        if ((counter - actionStart)> parent.timeLimit) {
            return true;
        }
        return false;
    }

    @Override
    protected void initialisation() {
        //actionStart = agent.getCurrentTime();
        super.initialisation();
        affType = ((SearchEnvironment) parent).affordance;
        agent.getLog().info("Start searching for: " + affType + " on behalf of " + parent.intention.getAncestorAction().name);
        this.agent.getAct().act(new Configuration().setAction(this.type.toString()).setName(this.type.toString() + " " + affType));
        //echoAction(type.toString() + " " + affType);
    }
}

class SearchEnvironment extends Action {

    public AffordanceType affordance = null;

    public SearchEnvironment(AffordanceType affordance, DecisionModuleImpl module, Intention intention) {
        super();
        this.satisfyingItems.put(affordance, null);
        this.affordance = affordance; // I double the variable as it is more handy to access it like this
        this.atomicActions = new ArrayList<AtomicAction>();
        this.atomicActions.add(new AtomicSearchEnvironment(this, module));
        this.name = "_Search Environment " + affordance;
        this.timeLimit = 2;
        this.activity = intention.getActivity();
        this.state = ActionStates.PRESTATE;
        this.intention = intention; // link to want:)
    }
}
