package decisionMakingSystem;

import java.io.Serializable;
import utils.TimeUtils;

/**
 * Takes care about time or more specifically about time changes.
 * Agent can travel to different time zones. As we have to cope with this in some ways
 * this class provides a way of setting the GMT at one place and operates with the time 
 * consistently keeping the counter (of ticks of logic) away from this.
 * @author Ondrej
 */
public final class GMTTime implements Serializable {
    /** The difference between the timezone of agent's origin and the timezone he is currently in. */
    private static double GMT_TIME = 0.0;
    
    protected GMTTime () {}

    public static double getGMT() {
        return GMT_TIME;
    }

    /**
     * Sets new difference and replans the plan. In fact it creates new plan
     * starting at the moment designated by the new time after the time switch.
     * @param GMT - note, that the difference must be in the interval (-12,12)
     * @param module - the current instance of DecisionModuleImpl
     */
    public static void setGMT(double GMT, DecisionModuleImpl module) {
        if (GMT > 12 || GMT < -12)
            throw new IllegalArgumentException();
        GMT_TIME = GMT;
        module.replan(GMT);
    }
    /**
     * Returns real time in the ticks of logic
     * @param counter
     * @return
     */
    public static int getRealTimeInTicks(int counter) {
        return counter + TimeUtils.minutesToTicksOfLogic(GMT_TIME*60);
    }
    /**
     * @param counter - ticks of logic
     * @return true if it is midnight
     */
    public static boolean isMidnight(int counter) {
        int tmp = counter + TimeUtils.minutesToTicksOfLogic(GMT_TIME*60);
        return (tmp % GlobalParameters.LENGHT_OF_A_DAY == 0);
    }
}