package decisionMakingSystem;

import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.communication.messages.GBObjectUpdate;
import java.io.Serializable;
import java.util.ArrayList;
import javax.xml.bind.annotation.*;

/**
 * General item class - serves to wrap all objects operable by an agent under one with additional
 * features like affordances, attractivity, fadeout etc.
 * 
 * Then item contains pointers to message object which could be either player, item, picked up item. that is defined
 * in the variable type.
 * 
 * @author Ondrej
 */
@XmlRootElement
public class EItem implements Cloneable, Serializable {

    /** affordances which item has    */
    private ArrayList<Affordance> affordances = null;
    /** current attractivity of the item    */
    private int attractivity = 0;
    /** basic attractivity    */
    private int basicAttractivity = 0;
    /** fadeout - when it reaches some limit, it is discarded from perceived objects    */
    private int fadeout = 0;
    /** class of the item - UT class    */
    public String classOfItem = null;
    /** name    */
    public String name = null;
    /** how much is the basic attractivity decreased - habituation */
    public int decreaseOfAttractivity = 0;
    /** link to the item itself */
    @XmlTransient
    public InfoMessage item = null;
    /** type of the message = PLAYER, ADD_ITEM, ITEM   */
    @XmlTransient
    public MessageType type = null;
    /** cathegory of an item */
    public ItemCathegory cathegory = null;
    private long id;
    private Location location = null;

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public EItem() {
    }

    public EItem(InfoMessage item, MessageType type) {
        this.item = item;
        this.type = type;
    }

    /**
     * copy constructor
     */
    private EItem(ArrayList<Affordance> affordances, int attractivity, int basicAttractivity,
            int fadeout, String classOfItem, String name, InfoMessage item, MessageType type,
            ItemCathegory cathegory) {
        this.affordances = (ArrayList<Affordance>) affordances.clone();
        this.attractivity = attractivity;
        this.basicAttractivity = basicAttractivity;
        this.classOfItem = classOfItem;
        this.fadeout = fadeout;
        this.name = name;
        this.item = item;
        this.type = type;
        this.cathegory = cathegory;
    }

    @Override
    public Object clone() {
        return new EItem(affordances, attractivity, basicAttractivity, fadeout, classOfItem, name, item, type, cathegory);
    }

    public void restartAttractivity() {
        attractivity = basicAttractivity;
    }

    public void increaseAttractivity() {
        attractivity++;
    }

    public void decreaseAttractivity() {
        attractivity = 0;
        decreaseOfAttractivity = basicAttractivity;
    }

    public ArrayList<Affordance> getAffordances() {
        return affordances;
    }

    public void setAffordances(ArrayList<Affordance> affordances) {
        this.affordances = affordances;
    }

    public int getAttractivity() {
        return attractivity;
    }

    public void setAttractivity(int attractivity) {
        this.attractivity = attractivity;
    }

    public int getBasicAttractivity() {
        return basicAttractivity;
    }

    public void setBasicAttractivity(int attractivity) {
        this.basicAttractivity = attractivity;
    }

    public int getFadeout() {
        return fadeout;
    }

    public void setFadeout(int fadeout) {
        this.fadeout = fadeout;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public String toString() {
        String temp = this.name + " has: Affordances" + this.affordances + " \n";
        if (this.item != null) {
            temp += this.item + "\n";
        }
        temp += "Cathegory: " + this.cathegory + " basic attractivity: " + this.basicAttractivity;
        temp += " decreased attractivity: " + this.decreaseOfAttractivity + " attractivity: " + this.attractivity;
        return temp;
    }

    /**
     * example of item - needed for sample xml file for itemParameters.xml
     * @return
     */
    public static EItem exampleItem() {
        EItem result = new EItem();
        Affordance aff1 = new Affordance();
        Affordance aff2 = new Affordance();
        aff1.type = AffordanceType.TO_CLEAN;
        result.cathegory = ItemCathegory.PICKABLE;
        result.affordances = new ArrayList<Affordance>();
        result.affordances.add(aff2);
        result.affordances.add(aff1);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (getClass() != o.getClass()) {
            return false;
        }
        final EItem other = (EItem) o;
        if (other.basicAttractivity != basicAttractivity) {
            return false;
        }
        if (!this.affordances.equals(other.affordances)) {
            return false;
        }
        if (!this.item.equals(other.item)) {
            return false;
        }
        if (!this.type.equals(other.type)) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (!other.cathegory.equals(this.cathegory)) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.affordances != null ? this.affordances.hashCode() : 0);
        hash = 89 * hash + this.basicAttractivity;
        hash = 89 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 89 * hash + (this.item != null ? this.item.hashCode() : 0);
        hash = 89 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 89 * hash + (this.cathegory != null ? this.cathegory.hashCode() : 0);
        return hash;
    }

    /**
     * returns item location
     * @return
     */
    public Location getLocation() {
        return location;
    }

    /**
     * changes attractivity of the provided affordance
     * @param activity
     * @param aff
     */
    void changeAffordaceActivity(int newAttractivity, AffordanceType aff) {
        for (Affordance affordance : this.getAffordances()) {
            if (affordance.type.equals(aff)) {
                affordance.attractivity = newAttractivity;
            }
        }
    }

    public String getName() {
        return name;
    }
}
