package decisionMakingSystem;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
/**
 * This class is a part of ScheduleEntry, it is actualy a triple: <br>
 * day of a week - 0: monday, 1: tuesday ...<br>
 * part of a day - 0: all day, 1: morning (8-12), 2: afternoon (14-18), 3: evenning (19-22)<br>
 * probability - probability, that the action will be inserted to the daily plan<br>
 * 
 * @author Ondrej
 */
@XmlRootElement
class DayPartProbability implements Serializable {
    @XmlElement
    /** day of a week */
    private int day = 0;
    @XmlElement
    /** part of a day */
    private int part = 0;
    @XmlElement
    /** probability of execution */
    private double probability = 0;
    
    public DayPartProbability () {}
    
    public DayPartProbability (int day, int part, double probability){
        this.day = day;
        this.part = part;
        this.probability = probability;
    }
    /**
     * @param day - day of a week
     * @param part - part of a day
     * @return true if there is some entry that 
     */
    public boolean corresponds(int day, int part) {
        if (this.day != day)
            return false;
        if (this.part == 0 || this.part == part)
            return true;
        return false;
    }
    @Override
    public String toString() {
        String result = "Day: " + day + " Part: " + part + " Probability: " + probability + " ";
        return result;
    }

    public double getProbability() {
        return this.probability;
    }
    
}