package decisionMakingSystem;

import java.io.Serializable;

/**
 * Affordance contains its type, attractivity and a counter.
 * It is used exclusively for items as they need to be attractive etc.
 * 
 * @author Ondrej
 */
public class Affordance implements Cloneable, Serializable {
    
    /** type of affordance */
    public AffordanceType type = null;
    /** attractivity of the item -> for that affordance - if it is one of the needed ones, it is higher*/
    public int attractivity = 0;
    /** how many times we searched for this affordance? */
    public int counter = 1;
    /** copy constructor */
    private Affordance(AffordanceType type, int attractivity, int counter) {
        this.type = type;
        this.attractivity = attractivity;
        this.counter = counter;
    }


    @Override
    public Object clone() {
        return new Affordance(type, attractivity, counter);
    }
    
    public Affordance() {    }
    
    public Affordance(AffordanceType type) {
        this.type = type;
    }
    
    @Override
    public String toString() {
        String temp = "Affordance: " + type + " attractivity: " + attractivity + " counter:" + counter;
        return temp;
    }
            
    public static void main (String [] args) {
        for (AffordanceType aff : AffordanceType.values()) {
            if (aff.toString().startsWith("_"))
                System.out.println(aff + " is a place");
            else
                System.out.println(aff + " is a thing");
        }                

    }
    
}