package bot;

import atomicActions.AtomicAction;
import decisionMakingSystem.Action;
import decisionMakingSystem.DecisionModule;
import decisionMakingSystem.Intention;
import utils.Interval;
import utils.TimeUtils;

/**
 * A container for the report of last iteration of DMS which is used then by Memory
 * to do an update.
 *
 * @author Ondrej Burkert
 */
public class DMSMemoryVO {

  private AtomicAction actualAtomicAction = null;
  private AtomicAction oldAtomicAction = null;
  private Intention actualIntention = null;
  private Action actualAction = null;
  private DecisionModule module = null;
  private int counter;
  private boolean night;
  private double GMT;
  private boolean verbose = false;
  private boolean GMTChanged = false;

  public DMSMemoryVO(DecisionModule module) {
    this.module = module;
    this.actualAction = module.getActualAction();
    this.actualIntention = module.getActualIntention();
    this.counter = module.getCounter();
    if (actualAction == null) {
      actualAtomicAction = null;
    } else {
      this.actualAtomicAction = actualAction.getCurrentAtomicAction();
    }
    this.oldAtomicAction = module.getOldAtomicAction(); 

    double hour = TimeUtils.counterToHours(counter);
    if (hour > 7 && hour < 21) {
      night = false;
    } else {
      night = true;
    }
    GMT = module.getGMTTime();
  }

  public AtomicAction getActualAtomicAction() {
    return actualAtomicAction;
  }

  public boolean getIsNight() {
    return night;
  }

  public AtomicAction getOldAtomicAction() {
    return oldAtomicAction;
  }

  public Intention getActualIntention() {
    return actualIntention;
  }

  public Action getActualAction() {
    return actualAction;
  }

  public void addIntention(String name, Interval actInterval) {
    module.addIntention(name, actInterval);
  }

  public int getCounter() {
    return counter;
  }

  public double getGMTTime() {
    return this.GMT;
  }

  public int getThoughtTimeTicks() {
    return counter + TimeUtils.minutesToTicksOfLogic(GMT * 60);
  }

  void setGMTChanged(boolean b) {
    GMTChanged = b;
  }

  void setVerbose(boolean verbose) {
    this.verbose = verbose;
  }

  public boolean isVerbose() {
    return verbose;
  }

  public boolean isGMTChanged() {
    return GMTChanged;
  }
}