package atomicActions.basic;

import atomicActions.AtomicAction;
import atomicActions.AtomicActions;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import bot.Bot;

import decisionMakingSystem.Action;
import java.io.Serializable;
/**
 * Take something.
 * @author Ondrej
 */
public class Take extends AtomicAction implements Serializable {

    @Override
    public boolean succeeded() {
        if ((counter - actionStart) > parent.timeLimit) {
            logFinished("Taking finished. Duration: " + counter + " rounds");
            agent.getAct().act(new Configuration().setAction("NONE"));
            return true;
        }
        return false;
    }

    @Override
    protected String getEnvironmentAction() {
        return "TAKE";
    }

    @Override
    public boolean failed() {
        return false;
    }

    @Override
    public void execute() {
        
        if (counter == 0) {
            agent.getLog().info("Taking something");
            initialisation();
        }

        counter = agent.getCurrentTime();
    }
    
    public Take (Action parent, Bot agent) {
        super(parent, agent);
        type = AtomicActions.TAKE;
    }

}