package atomicActions;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SendMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.TurnTo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import bot.Bot;
import decisionMakingSystem.Action;
import java.io.Serializable;
/**
 * Work, just say he is doing it
 * @author Ondrej
 */
public class Work extends AtomicAction implements Serializable {

    private int lastMessageSent = 0;

    private int messageDelay = 20;

    @Override
    public boolean succeeded() {
        if ((counter - actionStart) > parent.timeLimit) {
            logFinished("Working finished. Duration: " + counter + " rounds");
            return true;
        }
        return false;
    }

    @Override
    public boolean failed() {
        return false;
    }

    @Override
    public void execute() {
        
        if (counter == 0) {
            agent.getLog().info("Working");
            initialisation();
        }
        counter = agent.getCurrentTime();
        for (Player plr : agent.players.getVisiblePlayers().values()) {

            if (plr.getAction().toUpperCase().contains("WORK")) {
                this.agent.getAct().act(new TurnTo().setLocation(plr.getLocation()));

                if ((counter - lastMessageSent) > messageDelay) {
                    this.agent.getAct().act(new SendMessage().setText("*WORKING TOGETHER* Working sucks! What do you think mate?").setFadeOut(8d));
                    lastMessageSent = counter;
                }
                break;
            }
        }     
    }

    public Work (Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.WORK;
    }
}