package atomicActions;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import bot.Bot;
import decisionMakingSystem.Action;
import java.io.Serializable;
/**
 * WashFace, just say he is doing it
 * @author Ondrej
 */
public class WashFace extends AtomicAction implements Serializable {

    @Override
    public boolean succeeded() {
        if ((counter - actionStart) > parent.timeLimit) {
            logFinished("Wash face finished. Duration: " + counter + " rounds");
            return true;
        }
        return false;
    }
    
    @Override
    public boolean failed() {
        return false;
    }

    @Override
    public void execute() {
        
        if (counter == 0) {
            agent.getLog().info("Washing face");
            initialisation();
        }
        counter = agent.getCurrentTime();
    }
    
    public WashFace (Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.WASH_FACE;
    }

}