package atomicActions;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import bot.Bot;
import decisionMakingSystem.Action;
import java.io.Serializable;
/**
 * Swimming, no impact on the environment so far
 * @author Ondrej
 */
public class Swim extends AtomicAction implements Serializable {

    @Override
    public boolean succeeded() {
        if ((counter - actionStart) > parent.timeLimit) {
            logFinished("Swimming finished. Duration: " + counter + " rounds");
            return true;
        }
        return false;
    }
    
    @Override
    public boolean failed() {
        return false;
    }

    @Override
    public void execute() {
        
        if (counter == 0) {
            agent.getLog().info("Swimming");
            initialisation();
        }
        counter = agent.getCurrentTime();
    }
    
    public Swim (Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.SWIM;
    }

}