package atomicActions;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import bot.Bot;
import decisionMakingSystem.Action;
import java.io.Serializable;
/**
 * Shower, Showering as long as the time limit says
 * @author Ondrej
 */
public class Shower extends AtomicAction implements Serializable {

    @Override
    public boolean succeeded() {
        if ((counter - actionStart) > parent.timeLimit) {
            logFinished("Showering finished. Duration: " + counter + " rounds");
            return true;
        }
        return false;
    }
    
    @Override
    public boolean failed() {
        return false;
    }

    @Override
    public void execute() {
        
        if (counter == 0) {
            agent.getLog().info("Showering");
            initialisation();
        }
        counter = agent.getCurrentTime();
    }
    
    public Shower (Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.SHOWER;
    }

}