package atomicActions;


import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;

import decisionMakingSystem.Action;
import bot.Bot;
import java.io.Serializable;
import java.util.ArrayList;
/**
 * Run, just say he is doing it
 * @author Ondrej
 */
public class Run extends AtomicAction implements Serializable {
    
    ArrayList<Item> itemsToRunAround = null;
    @Override
    public void execute() {
        
        if (counter == 0) {
            agent.getLog().info("Run around items");
            initialisation();
        }
        this.agent.runAroundItemsInTheMap(itemsToRunAround, false);
        this.counter = agent.getCurrentTime();
    }

    @Override
    public boolean succeeded() {
        if ((counter - actionStart) > parent.timeLimit) {
            logFinished("Run finished. Duration: " + counter + " rounds");
            return true;
        }
        return false;
    }
    
    @Override
    public boolean failed() {
        if ((counter - actionStart) > parent.timeLimit) {
            return true;
        }
        return false;
    }

    public Run(Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.RUN;
    }

    @Override
    protected void initialisation() {
        super.initialisation();
        ArrayList<Item> weapons = this.agent.getKnownWeapons();
        itemsToRunAround = new ArrayList<Item>();
        for (Item weapon : weapons) {
            this.itemsToRunAround.add(weapon);
        }
    }
    
}