package atomicActions;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import decisionMakingSystem.Action;
import bot.Bot;
import java.io.Serializable;
import java.util.Random;

/**
 * available board games title: just for fun and to vary a bit the logs
 * => could be then presented by item though
 * 
 * @author Ondrej
 */
enum BoardGames {

    PuertoRico,
    Alhambra,
    Chess,
    Groenland,
    SettlersFromCatan,
    Carcassonne,
}

/**
 * PlayBoardGames, just say he is doing it
 * @author Ondrej
 */
public class PlayBoardGames extends AtomicAction implements Serializable {

    String gameTitle = null;

    @Override
    public boolean succeeded() {
        if ((counter - actionStart) > parent.timeLimit) {
            logFinished("Playing " + gameTitle + " finished. Duration: " + counter + " rounds");
            return true;
        }
        return false;
    }

    @Override
    public boolean failed() {
        if ((counter - actionStart) > parent.timeLimit) {
            return true;
        }
        return false;
    }

    @Override
    public void execute() {

        if (counter == 0) {
            initialisation();
            agent.getLog().info("Start playing " + gameTitle);
        }
        counter = agent.getCurrentTime();
    }

    public PlayBoardGames(Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.PLAY_BOARD_GAMES;
    }

    @Override
    protected void initialisation() {
        super.initialisation();
        Random random = new Random();
        // just get a game title from the enum - just for fun:)
        gameTitle = BoardGames.values()[random.nextInt(BoardGames.values().length)].toString();
    }
}
