package atomicActions;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import bot.Bot;
import decisionMakingSystem.Action;
import java.io.Serializable;
import java.util.Random;

/**
 * Seeing a movie, just say he is doing it
 * @author Ondrej
 */
public class Knit extends AtomicAction implements Serializable {

    @Override
    public boolean succeeded() {
        if ((counter - actionStart) > parent.timeLimit) {
            logFinished("Knitting finished. Duration: " + counter + " rounds");
            return true;
        }
        return false;
    }

    @Override
    public boolean failed() {
        return false;
    }

    @Override
    public void execute() {

        if (counter == 0) {
            initialisation();
            agent.getLog().info("Knitting.");
        }
        counter = agent.getCurrentTime();
    }

    public Knit(Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.KNIT;
    }

    @Override
    protected void initialisation() {
        super.initialisation();
    }
}