package atomicActions;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;

import decisionMakingSystem.Action;
import bot.Bot;
import java.io.Serializable;
/**
 * Jump, just say he is doing it and start jumping
 * @author Ondrej
 */
public class Jump extends AtomicAction implements Serializable {

    private int lastJumpTime = 0;

    private int jumpDelay = 4;

    @Override
    public boolean succeeded() {
        if ((counter - actionStart) > parent.timeLimit) {
            logFinished("Jumping finished. Duration: " + counter + " rounds");
            return true;
        }
        return false;
    }
    
    @Override
    public boolean failed() {
        if ((counter - actionStart) > parent.timeLimit) {
            return true;
        }
        return false;
    }

    
    @Override
    public void execute() {        
        if (counter == 0) {
            agent.getLog().info("Jumping");
            initialisation();
        }
        counter = agent.getCurrentTime();
        if (counter - lastJumpTime > jumpDelay ) {
            this.agent.getAct().act(new cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Jump());
        }       
    }
    
    public Jump (Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.JUMP;
    }

}