package atomicActions;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SendMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.TurnTo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import bot.Bot;
import decisionMakingSystem.Action;
import java.io.Serializable;
/**
 * JoinSomeoneDrinking
 * @author knight
 */
public class JoinSomeoneDrinking extends AtomicAction implements Serializable {

    private int lastMessageSent = 0;

    private int messageDelay = 5;

    @Override
    public boolean succeeded() {
        if ((counter - actionStart) > parent.timeLimit) {
            logFinished("Drinking finished. Duration: " + counter + " rounds");
            return true;
        }
        return false;
    }

    @Override
    public boolean failed() {
        return false;
    }

    @Override
    public void execute() {        
        if (counter == 0) {
            agent.getLog().info("Drinking");
            initialisation();
        }
        counter = agent.getCurrentTime();

        for (Player plr : agent.players.getVisiblePlayers().values()) {

            if (plr.getAction().toUpperCase().contains("JOIN_SOMEONE_DRINKING")) {
                this.agent.getAct().act(new TurnTo().setLocation(plr.getLocation()));

                if ((counter - lastMessageSent) > messageDelay) {
                    this.agent.getAct().act(new SendMessage().setText("Lets drink together! Cheers mate!").setFadeOut(8d));
                    lastMessageSent = counter;
                }
                break;
            }
        }
        
    }

    public JoinSomeoneDrinking (Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.JOIN_SOMEONE_DRINKING;
    }

}