package atomicActions;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;

import decisionMakingSystem.Action;
import bot.Bot;
import java.io.Serializable;
/**
 * ExplainRules, just say he is doing it
 * @author Ondrej
 */
public class ExplainRules extends AtomicAction implements Serializable {

    @Override
    public boolean succeeded() {
        if ((counter - actionStart) > parent.timeLimit) {
            logFinished("Rules explained. Duration: " + counter + " rounds");
            return true;
        }
        return false;
    }

    @Override
    public boolean failed() {
        return false;
    }

    @Override
    public void execute() {
        
        if (counter == 0) {
            agent.getLog().info("Explaing rules");
            initialisation();
        }
        counter = agent.getCurrentTime();
    }

    public ExplainRules (Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.EXPLAIN_GAME;
    }
}