package atomicActions;


//import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SendMessage;
//import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.TeamChat;
import decisionMakingSystem.Action;
import decisionMakingSystem.DecisionModuleImpl;
import decisionMakingSystem.EItem;
import decisionMakingSystem.ItemCathegory;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlRootElement;
import bot.Bot;

/**
 * atomic action is an element which links (roots) trees of plans with (to) the environment. They contain links to all 
 * important parts of architecture - decision module, agent itself and parental action thus it can perform
 * any action with agent, demand sensoric information, navigate through environment and work with parts of logic
 * like perceived items etc.
 * <br><br>
 * Atomic actions can be found typically in leaves of tree plans, but even internal nodes can have atomic actions, which
 * are executed after satisfaction of the node by its intentions. Important is, that only Actions can contain AtomicActions.
 * <br><br>
 * How is an atomic action performed? When it (decision making system) comes to the leaf and an atomic action is to be executed, 
 * it calls execute(), then it checks if atomic action failed() or succeeded() and if neither of those, it calls execute() 
 * again in the next logic iteration. So it is crucial to implement those three functions when creating new atomic action. 
 * Don't forget to raise counter in execute(), you can use its zero value to identify time for initialization, which can be 
 * necessary in some cases. Counter serves as well as a timeout so it should be compared to the value of timeOut of parental action
 * during failed().
 * 
 * This class should be abstract, but is not, as I haven't found a way how to bypass the XML loader so it will load directly the type of the atomic
 * action
 * 
 * @author Ondrej
 */
@XmlRootElement
public class AtomicAction implements Serializable {

    /** type of atomic action */
    public AtomicActions type = null;
    /** counter - 0 at the beginning, otherwise contains currentTime in the environment */
    public int counter = 0;
    /** time of when the action has been started */
    public int actionStart = 0;
    /** link to the agent */
    public transient Bot agent = null; // neni serializable
    /** link to parental Action */
  //  protected Action parent = null;
    public Action parent = null;
    /** link to the decision making module */
    public transient DecisionModuleImpl dModule = null; // taky neni serializable
    /** location agent should be at before the action execution */
    public Location location = null;
    /** if the agent logged succeeded message */
    private boolean logged = false;

    /** specified in XML file - used to determine when to delete node from episodic memory  */
    public int attractivity = 0;

    public AtomicAction() {
    }

    /** copy constructor */
    public AtomicAction(Action parent, Bot agent) {
        this.agent = agent;
        this.parent = parent;
    }

    AtomicAction(AtomicActions type) {
        this.type = type;
    }

    private Location getThePlace() {
        synchronized (parent.satisfyingItems) {
            if (parent.satisfyingItems != null) {
                for (EItem item : parent.satisfyingItems.values()) {
                    if (item == null) {
                        continue;
                    } else if (item.cathegory.equals(ItemCathegory.PLACE)) {
                        return item.getLocation();
                    }
                }
            }
        }
        return new Location(0, 0, 0); // no location required
    }

    /**
     * this method ensures, that bot is on the place he should be at
     * means it can have one affordance, which demands a location - like swimming needs a pool
     * and so it just ensures agent is on that location:)
     *
     * @return
     */
    public boolean checkIfOnThePlace() {
        // initialisation
        if (location == null) {
            location = getThePlace();
        }
        // no need for a place - action can be performed anywhere
        if (location.equals(new Location(0, 0, 0))) {
            return true;
        }
        // close enough
        if (agent.getLocation() != null) {
            if (agent.getLocation().getDistance(location) < 505) // TODO: should be changed to some value but only with new gameMap, as the old one has a 500 precision
            {
                return true;
            }
        }
        // run to it
        agent.safeRunToLocation(location);
        return false;
    }

    /**
     * executes the atomic action, typicaly writes something to log, change agent name, so we can see
     * in the environment what is he doing, raise counter
     */
    public void execute() {
        

        if (counter == 0) {
            initialisation();
        }
        counter = agent.getCurrentTime();
        // do something
    }

    /**
     * Note that if it returns false, it doesn't mean that it failed, it means that it just hasn't finished yet.
     * @return true if the atomic action was successfully performed, false if not
     */
    public boolean succeeded() {
        return false;
    }

    /**
     * Note that if it returns false, it doesn't mean that it succeeded, it means that it just hasn't finished yet.
     * @return true if the atomic action failed - usualy timeouted, false if not
     */
    public boolean failed() {
        if ((counter - actionStart) > parent.timeLimit) {
            return true;
        }
        // other conditions
        return false;
    }

    protected String getEnvironmentAction() {
        return type.toString();
    }

    /**
     * initialization which has to be done prior first execution of atomic action
     */
    protected void initialisation() {
        String actionStr = type.toString();
//        this.agent.getAct().act(new Configuration().setAction(this.type.toString()).setName(this.type.toString() + " " + affType));
        agent.getAct().act(new Configuration().setAction(getEnvironmentAction()).setName(actionStr));
        echoAction(actionStr);
        actionStart = agent.getCurrentTime();
        // initialization of whatever necessary
    }

    /**
     * Display the action identification in simulation environment.
     * @param action
     */
    protected void echoAction(String action) {
        agent.getAct().act(new SendMessage(null, action, true, 100d));
    }
    
    public void terminalisation() {
        // whatever needs to be done then action is terminated - e.g. biochanges
    }

    @Override
    public boolean equals(Object obj) {
        String obj1, obj2;
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        AtomicAction tmp = (AtomicAction) obj;
        obj1 = this.type.name() + this.counter + this.location + this.parent.toString();
        obj2 = this.type.name() + this.counter + this.location + this.parent.toString();
        if (obj1.equals(obj2)) {
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 37 * hash + (this.parent != null ? this.parent.hashCode() : 0);
        hash = 37 * hash + (this.location != null ? this.location.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        String result = this.type.name() + " | " + this.parent.name + " | " + this.counter;
        return result;
    }

    public void logFinished(String text) {
        if (!logged) {
            this.agent.getLog().info(text);
        }
        logged = true;
    }
}
