/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class Interval
implements Cloneable,
Serializable {
    @XmlElement
    private int leftSide = 0;
    @XmlElement
    private int rightSide = 0;
    @XmlElement
    private int value = 0;

    public boolean isInInterval(int x) {
        return x >= this.getLeftSide() && x <= this.getRightSide();
    }

    public Interval(int a, int b, int value) {
        this.leftSide = a;
        this.rightSide = b;
        this.value = value;
    }

    public Interval() {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this == null || obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        Interval tmp = (Interval)obj;
        return tmp.rightSide == this.rightSide && tmp.leftSide == this.leftSide && tmp.value == this.value;
    }

    public Object clone() {
        return new Interval(this.leftSide, this.rightSide, this.value);
    }

    public int getRightSide() {
        return this.rightSide;
    }

    public int getLeftSide() {
        return this.leftSide;
    }

    public int getIntervalSize() {
        if (this.rightSide - this.leftSide > 0) {
            return this.rightSide - this.leftSide;
        }
        return 0;
    }

    public int valueInTime(int x) {
        if (this.isInInterval(x)) {
            return this.getValue();
        }
        return 0;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return "(<" + this.leftSide + ", " + this.rightSide + ">; " + this.value + ")";
    }
}

