/*
 * Decompiled with CFR 0.152.
 */
package bot;

import bot.ActionManager;
import bot.Bot;
import bot.ExperimentController;
import bot.FileLog;
import decisionMakingSystem.DMSLogger;
import decisionMakingSystem.GlobalParameters;
import java.io.File;
import java.io.Serializable;
import java.util.logging.Logger;
import utils.FileSaveLoadUtils;
import utils.TimeUtils;

public class ExperimentControllerImpl
implements ExperimentController,
Serializable {
    private String networkImagePath;
    private String memoryPath;
    private String gmtVizPath;
    private String decisionsPath;
    private String experimentControllerPath;
    private String connectionsPath;
    private int dayCounter = 0;
    private int hourCounter;
    private ActionManager actionManager = new ActionManager();
    private long explorationPeriod = 0L;
    private static String experimentCounter = "";
    private String directory;
    private String experimentDir;
    private long internalCounter = 0L;
    private transient DMSLogger dmsLogger = null;
    private transient FileLog experimentLogger = null;
    private transient FileLog extraLogger = null;
    private transient Logger log;
    private transient Bot agent;
    private int conceptNodesLearned = 8;
    private int totalDays = 36;

    public ExperimentControllerImpl(Logger log, String directory, Bot agent) {
        this.log = log;
        this.directory = directory;
        this.agent = agent;
        this.totalDays = agent.lifeTime;
    }

    static ExperimentController loadFromFile(String path, Logger log, Bot agent) {
        ExperimentControllerImpl exp = (ExperimentControllerImpl)FileSaveLoadUtils.loadObject(path, log);
        exp.log = log;
        exp.agent = agent;
        exp.dmsLogger = new DMSLogger(log, exp.experimentDir + "agent" + experimentCounter + ".log");
        exp.experimentLogger = new DMSLogger(log, exp.experimentDir + "experiment" + experimentCounter + ".log");
        return exp;
    }

    @Override
    public void controlExperiment() {
        this.saveToFiles();
        this.hourCounter = 0;
        this.actionManager.doEveryDayActions(this.dayCounter);
        ++this.dayCounter;
        this.controlExperimentLongLife();
    }

    @Override
    public void prepareExperiment() {
        experimentCounter = TimeUtils.now("yyyy-MM-dd_HH.mm.ss.SSS");
        this.experimentDir = this.directory + "experiment" + experimentCounter + File.separator;
        File td = new File(this.experimentDir);
        if (td.mkdir()) {
            this.log.config("Directory for the experiment was prepared.");
        } else {
            this.log.fine("Experiment's directory not created! Existing?");
        }
        this.dmsLogger = new DMSLogger(this.log, this.experimentDir + "_agent" + experimentCounter + ".log");
        this.experimentLogger = new DMSLogger(this.log, this.experimentDir + "_experiment" + experimentCounter + ".log");
        this.extraLogger = new DMSLogger(this.log, this.experimentDir + "_extraLog" + experimentCounter + ".log");
        this.networkImagePath = this.experimentDir + "Image";
        this.memoryPath = this.experimentDir + "Memory";
        this.gmtVizPath = this.experimentDir + "GMT";
        this.decisionsPath = this.experimentDir + "DMS";
        this.experimentControllerPath = this.experimentDir + "ExpController";
        this.connectionsPath = this.experimentDir + "Connections";
    }

    @Override
    public void hourUpdate() {
        this.actionManager.doEveryHourActions(this.gmtVizPath, this.dayCounter, this.hourCounter);
        ++this.hourCounter;
    }

    @Override
    public FileLog getExperimentLogger() {
        return this.experimentLogger;
    }

    private void controlExperimentLongLife() {
        int day = (int)((this.internalCounter - this.explorationPeriod) / (long)GlobalParameters.LENGHT_OF_A_DAY);
        if (day == this.conceptNodesLearned) {
            this.getExperimentLogger().logToFile("Slowing down learning rate.");
        }
        if (day == this.totalDays) {
            this.agent.agent.kill();
        }
    }

    private void controlExperimentTwoPlans() {
        int day = (int)((this.internalCounter - this.explorationPeriod) / (long)GlobalParameters.LENGHT_OF_A_DAY);
        if (day == this.conceptNodesLearned) {
            this.getExperimentLogger().logToFile("Changing to a holidays lifestyle!");
            this.agent.getDMS().changeLifestyle(this.directory, "Holidays.xml", 580);
        }
        if (day == this.conceptNodesLearned + 12) {
            this.agent.agent.kill();
        }
    }

    private void saveToFile(String fileName) {
        FileSaveLoadUtils.saveObject(this, fileName, this.log);
    }

    private void saveToFiles() {
        this.saveToFile(this.fileCounterPrefix(this.experimentControllerPath));
        this.agent.getDMS().saveToFile(this.fileCounterPrefix(this.decisionsPath));
    }

    public String fileCounterPrefix(String path) {
        return FileSaveLoadUtils.fileCounterPrefix(path, this.dayCounter, this.hourCounter);
    }

    @Override
    public void increaseInternalCounter(double time) {
        this.internalCounter = Math.round(time + 1.0);
    }

    @Override
    public long getInternalCounter() {
        return this.internalCounter;
    }

    @Override
    public DMSLogger getDMSLogger() {
        return this.dmsLogger;
    }

    @Override
    public FileLog getExtraLogger() {
        return this.extraLogger;
    }

    @Override
    public void cleanUp() {
        this.getDMSLogger().cleanUp();
        this.getExperimentLogger().cleanUp();
        this.getExtraLogger().cleanUp();
        this.actionManager.cleanUp();
    }
}

