/*
 * Decompiled with CFR 0.152.
 */
package bot;

import atomicActions.AtomicAction;
import decisionMakingSystem.Action;
import decisionMakingSystem.DecisionModule;
import decisionMakingSystem.Intention;
import utils.Interval;
import utils.TimeUtils;

public class DMSMemoryVO {
    private AtomicAction actualAtomicAction = null;
    private AtomicAction oldAtomicAction = null;
    private Intention actualIntention = null;
    private Action actualAction = null;
    private DecisionModule module = null;
    private int counter;
    private boolean night;
    private double GMT;
    private boolean verbose = false;
    private boolean GMTChanged = false;

    public DMSMemoryVO(DecisionModule module) {
        this.module = module;
        this.actualAction = module.getActualAction();
        this.actualIntention = module.getActualIntention();
        this.counter = module.getCounter();
        this.actualAtomicAction = this.actualAction == null ? null : this.actualAction.getCurrentAtomicAction();
        this.oldAtomicAction = module.getOldAtomicAction();
        double hour = TimeUtils.counterToHours(this.counter);
        this.night = !(hour > 7.0) || !(hour < 21.0);
        this.GMT = module.getGMTTime();
    }

    public AtomicAction getActualAtomicAction() {
        return this.actualAtomicAction;
    }

    public boolean getIsNight() {
        return this.night;
    }

    public AtomicAction getOldAtomicAction() {
        return this.oldAtomicAction;
    }

    public Intention getActualIntention() {
        return this.actualIntention;
    }

    public Action getActualAction() {
        return this.actualAction;
    }

    public void addIntention(String name, Interval actInterval) {
        this.module.addIntention(name, actInterval);
    }

    public int getCounter() {
        return this.counter;
    }

    public double getGMTTime() {
        return this.GMT;
    }

    public int getThoughtTimeTicks() {
        return this.counter + TimeUtils.minutesToTicksOfLogic(this.GMT * 60.0);
    }

    void setGMTChanged(boolean b) {
        this.GMTChanged = b;
    }

    void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isGMTChanged() {
        return this.GMTChanged;
    }
}

