/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.planning4j.external.plannerspack;

import cz.cuni.amis.planning4j.PlanningException;
import cz.cuni.amis.planning4j.external.impl.itsimple.EPlannerPlatform;
import cz.cuni.amis.planning4j.external.impl.itsimple.ItSimplePlannerInformation;
import cz.cuni.amis.planning4j.external.impl.itsimple.ItSimpleUtils;
import cz.cuni.amis.planning4j.external.impl.itsimple.PlannerArgument;
import cz.cuni.amis.planning4j.external.impl.itsimple.PlannerListManager;
import cz.cuni.amis.planning4j.external.impl.itsimple.SimplePlannerListManager;
import cz.cuni.amis.planning4j.external.impl.itsimple.XMLUtilities;
import java.io.File;
import java.io.InputStream;

public class PlannersPackUtils {
    private static final PlannerPackListManager plannerPackListManager = new PlannerPackListManager();
    private static final SimplePlannerListManager installedPlannerListManager = new SimplePlannerListManager(XMLUtilities.readPlannerListFromStream((InputStream)PlannersPackUtils.class.getResourceAsStream("/planners/installedPlanners.xml")));

    public static PlannerListManager getPlannerListManager() {
        return plannerPackListManager;
    }

    public static SimplePlannerListManager getInstalledPlannerListManager() {
        return installedPlannerListManager;
    }

    public static ItSimplePlannerInformation getBlackBox() {
        return PlannersPackUtils.getPlannerListManager().getPlannerByName("Blackbox");
    }

    public static ItSimplePlannerInformation getMetricFF() {
        return PlannersPackUtils.getPlannerListManager().getPlannerByName("Metric-FF");
    }

    public static ItSimplePlannerInformation getSGPlan6() {
        return PlannersPackUtils.getPlannerListManager().getPlannerByName("SGPlan 6");
    }

    public static ItSimplePlannerInformation getFastDownwardTemplate() {
        return installedPlannerListManager.getPlannerByName("Fast Downward");
    }

    public static ItSimplePlannerInformation getFastDownwardIPCConfiguration(String configuratioName) {
        ItSimplePlannerInformation info = PlannersPackUtils.getFastDownwardTemplate();
        if (info == null) {
            throw new PlanningException("Fast downward not found");
        }
        info.getSettings().addAdditionalArgument(new PlannerArgument("ipc", configuratioName));
        return info;
    }

    public static ItSimplePlannerInformation getLAMA2011() {
        return PlannersPackUtils.getFastDownwardIPCConfiguration("seq-sat-lama-2011");
    }

    public static ItSimplePlannerInformation getProbe() {
        return installedPlannerListManager.getPlannerByName("PROBE");
    }

    private static class PlannerPackListManager
    extends PlannerListManager {
        public PlannerPackListManager() {
            super(XMLUtilities.readPlannerListFromStream((InputStream)PlannersPackUtils.class.getResourceAsStream("/planners/itPlanners.xml")));
        }

        public void extractAndPreparePlanner(File targetDirectory, ItSimplePlannerInformation selectedPlanner) {
            super.extractAndPreparePlanner(targetDirectory, selectedPlanner);
            if (ItSimpleUtils.getOperatingSystem() == EPlannerPlatform.WINDOWS) {
                this.extractFileIfNotExists(new File(targetDirectory, "planners/cygwin1.dll"), "/planners/cygwin1.dll");
            }
        }
    }
}

