/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.conic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import math.geom2d.AffineTransform2D;
import math.geom2d.Angle2D;
import math.geom2d.Box2D;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.circulinear.CircleLine2D;
import math.geom2d.circulinear.CirculinearCurve2DUtils;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.CirculinearElement2D;
import math.geom2d.conic.Circle2D;
import math.geom2d.conic.CircularShape2D;
import math.geom2d.conic.EllipseArc2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.Curve2DUtils;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.curve.SmoothCurve2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.line.Ray2D;
import math.geom2d.line.StraightLine2D;
import math.geom2d.transform.CircleInversion2D;

public class CircleArc2D
extends EllipseArc2D
implements Cloneable,
CircularShape2D,
CirculinearElement2D {
    protected Circle2D circle;

    public CircleArc2D() {
        this(0.0, 0.0, 1.0, 0.0, 1.5707963267948966);
    }

    public CircleArc2D(Circle2D circle, double startAngle, double angleExtent) {
        this(circle.xc, circle.yc, circle.r, startAngle, angleExtent);
    }

    public CircleArc2D(Circle2D circle, double startAngle, double endAngle, boolean direct) {
        this(circle.xc, circle.yc, circle.r, startAngle, endAngle, direct);
    }

    public CircleArc2D(Point2D center, double radius, double startAngle, double angleExtent) {
        this(center.getX(), center.getY(), radius, startAngle, angleExtent);
    }

    public CircleArc2D(Point2D center, double radius, double start, double end, boolean direct) {
        this(center.getX(), center.getY(), radius, start, end, direct);
    }

    public CircleArc2D(double xc, double yc, double r, double start, double end, boolean direct) {
        super(xc, yc, r, r, 0.0, start, end, direct);
        this.circle = new Circle2D(xc, yc, r);
        this.ellipse = this.circle;
    }

    public CircleArc2D(double xc, double yc, double r, double start, double extent) {
        super(xc, yc, r, r, 0.0, start, extent);
        this.circle = new Circle2D(xc, yc, r);
        this.ellipse = this.circle;
    }

    public static CircleArc2D create(Circle2D support, double startAngle, double angleExtent) {
        return new CircleArc2D(support, startAngle, angleExtent);
    }

    public static CircleArc2D create(Circle2D support, double startAngle, double endAngle, boolean direct) {
        return new CircleArc2D(support, startAngle, endAngle, direct);
    }

    public static CircleArc2D create(Point2D center, double radius, double startAngle, double angleExtent) {
        return new CircleArc2D(center, radius, startAngle, angleExtent);
    }

    public static CircleArc2D create(Point2D center, double radius, double startAngle, double endAngle, boolean direct) {
        return new CircleArc2D(center, radius, startAngle, endAngle, direct);
    }

    private double positionToAngle(double t) {
        if (t > Math.abs(this.angleExtent)) {
            t = Math.abs(this.angleExtent);
        }
        if (t < 0.0) {
            t = 0.0;
        }
        if (this.angleExtent < 0.0) {
            t = -t;
        }
        return t += this.startAngle;
    }

    @Deprecated
    public Circle2D getSupportCircle() {
        return this.circle;
    }

    @Deprecated
    public void setCenter(Point2D point) {
        this.circle.xc = point.getX();
        this.circle.yc = point.getY();
    }

    @Deprecated
    public void setRadius(double r) {
        this.circle.r = r;
    }

    @Deprecated
    public void setArc(Point2D center, double radius, double start, double extent) {
        this.circle.xc = center.getX();
        this.circle.yc = center.getY();
        this.circle.r = radius;
        this.startAngle = start;
        this.angleExtent = extent;
    }

    @Override
    public Circle2D getSupportingCircle() {
        return this.circle;
    }

    @Override
    public CirculinearDomain2D getBuffer(double dist) {
        return CirculinearCurve2DUtils.computeBuffer(this, dist);
    }

    @Override
    public CircleArc2D getParallel(double dist) {
        double r = this.circle.getRadius();
        double r2 = Math.max(this.angleExtent > 0.0 ? r + dist : r - dist, 0.0);
        return new CircleArc2D(this.circle.getCenter(), r2, this.startAngle, this.angleExtent);
    }

    @Override
    public double getLength() {
        return this.circle.getRadius() * Math.abs(this.angleExtent);
    }

    @Override
    public double getLength(double pos) {
        return pos * this.circle.getRadius();
    }

    @Override
    public double getPosition(double length) {
        return length / this.circle.getRadius();
    }

    @Override
    public CirculinearElement2D transform(CircleInversion2D inv) {
        Point2D center = inv.getCenter();
        Point2D p1 = this.getFirstPoint().transform(inv);
        Point2D p2 = this.getLastPoint().transform(inv);
        CircleLine2D element = this.circle.transform(inv);
        if (element instanceof Circle2D) {
            return new CircleArc2D((Circle2D)element, Angle2D.getHorizontalAngle(center, p1), Angle2D.getHorizontalAngle(center, p2), !this.isDirect());
        }
        if (element instanceof StraightLine2D) {
            return new LineSegment2D((java.awt.geom.Point2D)p1, p2);
        }
        System.err.println("CircleArc2D.transform(): error in transforming circle by inversion");
        return null;
    }

    @Override
    public double getWindingAngle(java.awt.geom.Point2D point) {
        Point2D p1 = this.getFirstPoint();
        Point2D p2 = this.getLastPoint();
        double angle1 = Angle2D.getHorizontalAngle(point, p1);
        double angle2 = Angle2D.getHorizontalAngle(point, p2);
        boolean b1 = new StraightLine2D((java.awt.geom.Point2D)p1, (java.awt.geom.Point2D)p2).isInside(point);
        boolean b2 = this.ellipse.isInside(point);
        if (this.angleExtent > 0.0) {
            if (b1 || b2) {
                if (angle2 > angle1) {
                    return angle2 - angle1;
                }
                return Math.PI * 2 - angle1 + angle2;
            }
            if (angle2 > angle1) {
                return angle2 - angle1 - Math.PI * 2;
            }
            return angle2 - angle1;
        }
        if (!b1 || b2) {
            if (angle1 > angle2) {
                return angle2 - angle1;
            }
            return angle2 - angle1 - Math.PI * 2;
        }
        if (angle1 > angle2) {
            return angle2 - angle1 + Math.PI * 2;
        }
        return angle2 - angle1;
    }

    @Override
    public boolean isInside(java.awt.geom.Point2D point) {
        return this.getSignedDistance(point.getX(), point.getY()) < 0.0;
    }

    @Override
    public double getSignedDistance(java.awt.geom.Point2D p) {
        return this.getSignedDistance(p.getX(), p.getY());
    }

    @Override
    public double getSignedDistance(double x, double y) {
        double dist = this.getDistance(x, y);
        Point2D point = new Point2D(x, y);
        boolean direct = this.angleExtent > 0.0;
        boolean inCircle = this.circle.isInside(point);
        if (inCircle) {
            return this.angleExtent > 0.0 ? -dist : dist;
        }
        Point2D p1 = this.circle.getPoint(this.startAngle);
        Point2D p2 = this.circle.getPoint(this.startAngle + this.angleExtent);
        boolean onLeft = new StraightLine2D((java.awt.geom.Point2D)p1, (java.awt.geom.Point2D)p2).isInside(point);
        if (direct && !onLeft) {
            return dist;
        }
        if (!direct && onLeft) {
            return -dist;
        }
        boolean left1 = new Ray2D(p1, this.circle.getTangent(this.startAngle)).isInside(point);
        if (direct && !left1) {
            return dist;
        }
        if (!direct && left1) {
            return -dist;
        }
        boolean left2 = new Ray2D(p2, this.circle.getTangent(this.startAngle + this.angleExtent)).isInside(point);
        if (direct && !left2) {
            return dist;
        }
        if (!direct && left2) {
            return -dist;
        }
        if (direct) {
            return -dist;
        }
        return dist;
    }

    @Override
    public Vector2D getTangent(double t) {
        t = this.positionToAngle(t);
        double r = this.circle.getRadius();
        if (this.angleExtent > 0.0) {
            return new Vector2D(-r * Math.sin(t), r * Math.cos(t));
        }
        return new Vector2D(r * Math.sin(t), -r * Math.cos(t));
    }

    public Collection<? extends CircleArc2D> getSmoothPieces() {
        ArrayList<CircleArc2D> list = new ArrayList<CircleArc2D>(1);
        list.add(this);
        return list;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public double getT0() {
        return 0.0;
    }

    @Override
    public double getT1() {
        return Math.abs(this.angleExtent);
    }

    @Override
    public Point2D getPoint(double t) {
        t = this.positionToAngle(t);
        return this.circle.getPoint(t);
    }

    @Override
    public double getPosition(java.awt.geom.Point2D point) {
        double angle = Angle2D.getHorizontalAngle(this.circle.getCenter(), point);
        if (this.containsAngle(angle)) {
            if (this.angleExtent > 0.0) {
                return Angle2D.formatAngle(angle - this.startAngle);
            }
            return Angle2D.formatAngle(this.startAngle - angle);
        }
        return this.getFirstPoint().distance(point) < this.getLastPoint().distance(point) ? 0.0 : Math.abs(this.angleExtent);
    }

    @Override
    public Collection<Point2D> getIntersections(LinearShape2D line) {
        return Circle2D.getIntersections(this, line);
    }

    @Override
    public double project(java.awt.geom.Point2D point) {
        double angle = this.circle.project(point);
        if (Angle2D.containsAngle(this.startAngle, this.startAngle + this.angleExtent, angle, this.angleExtent > 0.0)) {
            if (this.angleExtent > 0.0) {
                return Angle2D.formatAngle(angle - this.startAngle);
            }
            return Angle2D.formatAngle(this.startAngle - angle);
        }
        Point2D p1 = this.getFirstPoint();
        Point2D p2 = this.getLastPoint();
        if (p1.getDistance(point) < p2.getDistance(point)) {
            return 0.0;
        }
        return Math.abs(this.angleExtent);
    }

    @Override
    public double getDistance(java.awt.geom.Point2D p) {
        return this.getDistance(p.getX(), p.getY());
    }

    @Override
    public double getDistance(double x, double y) {
        double angle = Angle2D.getHorizontalAngle(this.circle.xc, this.circle.yc, x, y);
        if (this.containsAngle(angle)) {
            return Math.abs(Point2D.getDistance(this.circle.xc, this.circle.yc, x, y) - this.circle.r);
        }
        return Math.min(this.getFirstPoint().getDistance(x, y), this.getLastPoint().getDistance(x, y));
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public CircleArc2D getSubCurve(double t0, double t1) {
        if (this.angleExtent > 0.0) {
            t0 = Angle2D.formatAngle(this.startAngle + t0);
            t1 = Angle2D.formatAngle(this.startAngle + t1);
        } else {
            t0 = Angle2D.formatAngle(this.startAngle - t0);
            t1 = Angle2D.formatAngle(this.startAngle - t1);
        }
        if (!Angle2D.containsAngle(this.startAngle, this.startAngle + this.angleExtent, t0, this.angleExtent > 0.0)) {
            t0 = this.startAngle;
        }
        if (!Angle2D.containsAngle(this.startAngle, this.startAngle + this.angleExtent, t1, this.angleExtent > 0.0)) {
            t1 = Angle2D.formatAngle(this.startAngle + this.angleExtent);
        }
        return new CircleArc2D(this.circle, t0, t1, this.angleExtent > 0.0);
    }

    @Override
    public CircleArc2D getReverseCurve() {
        return new CircleArc2D(this.circle, Angle2D.formatAngle(this.startAngle + this.angleExtent), -this.angleExtent);
    }

    public Collection<? extends CircleArc2D> getContinuousCurves() {
        return CircleArc2D.wrapCurve(this);
    }

    @Override
    public CurveSet2D<CircleArc2D> clip(Box2D box) {
        CurveSet2D<SmoothCurve2D> set = Curve2DUtils.clipSmoothCurve((SmoothCurve2D)this, box);
        CurveArray2D<CircleArc2D> result = new CurveArray2D<CircleArc2D>(set.getCurveNumber());
        for (Curve2D curve2D : set.getCurves()) {
            if (!(curve2D instanceof CircleArc2D)) continue;
            result.addCurve((CircleArc2D)curve2D);
        }
        return result;
    }

    @Override
    public EllipseArc2D transform(AffineTransform2D trans) {
        boolean b2;
        if (!AffineTransform2D.isSimilarity(trans)) {
            return super.transform(trans);
        }
        Point2D center = this.circle.getCenter();
        Point2D point1 = this.getFirstPoint();
        Point2D point2 = this.getLastPoint();
        center = center.transform(trans);
        point1 = point1.transform(trans);
        point2 = point2.transform(trans);
        double angle1 = Angle2D.getHorizontalAngle(center, point1);
        double angle2 = Angle2D.getHorizontalAngle(center, point2);
        double[] coefs = trans.getCoefficients();
        double factor = Math.sqrt(coefs[0] * coefs[0] + coefs[3] * coefs[3]);
        double xc = center.getX();
        double yc = center.getY();
        double r2 = this.circle.getRadius() * factor;
        double startAngle = angle1;
        double angleExtent = Angle2D.formatAngle(angle2 - angle1);
        boolean b1 = AffineTransform2D.isDirect(trans);
        if (b1 & !(b2 = this.isDirect()) | !b1 & b2) {
            angleExtent -= Math.PI * 2;
        }
        return new CircleArc2D(xc, yc, r2, startAngle, angleExtent);
    }

    @Override
    public boolean contains(java.awt.geom.Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean contains(double x, double y) {
        double r = this.circle.getRadius();
        if (Math.abs(Point2D.getDistance(this.circle.xc, this.circle.yc, x, y) - r) > 1.0E-12) {
            return false;
        }
        double angle = Angle2D.getHorizontalAngle(this.circle.xc, this.circle.yc, x, y);
        return this.containsAngle(angle);
    }

    @Override
    public String toString() {
        Point2D center = this.circle.getCenter();
        return String.format(Locale.US, "CircleArc2D(%7.2f,%7.2f,%7.2f,%7.5f,%7.5f)", center.getX(), center.getY(), this.circle.getRadius(), this.getStartAngle(), this.getAngleExtent());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof EllipseArc2D)) {
            return false;
        }
        if (!(obj instanceof CircleArc2D)) {
            return super.equals(obj);
        }
        CircleArc2D arc = (CircleArc2D)obj;
        if (Math.abs(this.circle.xc - arc.circle.xc) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.circle.yc - arc.circle.yc) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.circle.r - arc.circle.r) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.circle.r1 - arc.circle.r1) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.circle.r2 - arc.circle.r2) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.circle.theta - arc.circle.theta) > 1.0E-12) {
            return false;
        }
        if (Math.abs(Angle2D.formatAngle(this.startAngle) - Angle2D.formatAngle(arc.startAngle)) > 1.0E-12) {
            return false;
        }
        return !(Math.abs(Angle2D.formatAngle(this.angleExtent) - Angle2D.formatAngle(arc.angleExtent)) > 1.0E-12);
    }

    @Override
    public CircleArc2D clone() {
        return new CircleArc2D(this.circle.clone(), this.startAngle, this.angleExtent);
    }
}

