/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.introspection.jmx;

import cz.cuni.amis.introspection.Folder;
import cz.cuni.amis.introspection.IntrospectionException;
import cz.cuni.amis.introspection.Test01_JavaIntrospection;
import cz.cuni.amis.introspection.java.Introspector;
import cz.cuni.amis.introspection.jmx.DynamicMBeanToFolderAdapter;
import cz.cuni.amis.introspection.jmx.DynamicProxy;
import cz.cuni.amis.introspection.jmx.FolderMBean;
import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class Test01_Jmx {
    static MBeanServer mbs = null;
    static JMXConnectorServer cs = null;
    static Test01_JavaIntrospection.Person person = null;

    @BeforeClass
    public static void setUpClass() throws RemoteException, MalformedURLException, IOException {
        Registry r = LocateRegistry.createRegistry(9999);
        mbs = MBeanServerFactory.createMBeanServer();
        person = new Test01_JavaIntrospection.Person("Alice Aho", 23);
        Test01_Jmx.person.knows = new Test01_JavaIntrospection.Person("Bob", 30);
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:9999/server");
        cs = JMXConnectorServerFactory.newJMXConnectorServer(url, null, mbs);
        if (cs == null) {
            throw new RuntimeException("Could not setUpClass() for test! JMXConnectorServerFactory.newJMXConnectorServer FAILED (Returned null...)! Url: " + url + ", mbs: " + mbs);
        }
        cs.start();
        System.out.println("Registry created / JMX connector started.");
    }

    @AfterClass
    public static void tearDownClass() throws IOException {
        if (cs != null) {
            cs.stop();
            System.out.println("JMX connector stopped");
        }
    }

    @Test
    public void exportMBean() throws MalformedURLException, IOException, JMException, IntrospectionException {
        Folder folder = Introspector.getFolder((String)"Alice", (Object)person);
        FolderMBean.exportFolderHierarchy((Folder)folder, (MBeanServer)mbs, (String)"myDomain", (String)"tutorial");
        System.out.println("---/// TEST OK ///---");
    }

    @Test
    public void changeExportedFolderRemotely() throws MalformedURLException, IOException, MalformedObjectNameException, IntrospectionException {
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:9999/server");
        JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
        MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
        ObjectName agentName = ObjectName.getInstance("myDomain:name=Alice,type=tutorial");
        DynamicProxy proxy = new DynamicProxy(agentName, mbsc);
        DynamicMBeanToFolderAdapter jmxFolder = new DynamicMBeanToFolderAdapter(proxy);
        String newName = "Cecil Corn";
        jmxFolder.getFolder("knows").getProperty("name").setValue((Object)newName);
        Assert.assertTrue((boolean)Test01_Jmx.person.knows.name.equals(newName));
        System.out.println("---/// TEST OK ///---");
    }

    private static void waitForEnterPressed() {
        try {
            System.out.println("\nPress <Enter> to continue...");
            System.in.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

