/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.sposh.debugger;

import java.util.Arrays;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;

public class BreakpointManager {
    private final String[] classFilter;
    private final String methodName;
    private final String methodSignature;
    private final String breakpointGroup;
    private MethodBreakpoint methodBreakpoint;
    public static final String LAP_ENGINE_CLASS = "cz.cuni.amis.pogamut.sposh.engine.PoshEngine";
    public static final String LAP_METHOD_NAME = "evaluatePlan";
    public static final String LAP_METHOD_SIGNATURE = "(Lcz/cuni/amis/pogamut/sposh/executor/IWorkExecutor;)Lcz/cuni/amis/pogamut/sposh/engine/PoshEngine$EvaluationResultInfo;";

    private BreakpointManager(String classFQN, String methodName, String methodSignature, String breakpointGroup) {
        this.classFilter = new String[]{classFQN};
        this.methodName = methodName;
        this.methodSignature = methodSignature;
        this.breakpointGroup = breakpointGroup;
    }

    public static BreakpointManager createLapEvaluation(String breakpointGroup) {
        return new BreakpointManager(LAP_ENGINE_CLASS, LAP_METHOD_NAME, LAP_METHOD_SIGNATURE, breakpointGroup);
    }

    private MethodBreakpoint createBreakpoint() {
        MethodBreakpoint bp = MethodBreakpoint.create();
        bp.setClassFilters(this.classFilter);
        bp.setMethodName(this.methodName);
        bp.setMethodSignature(this.methodSignature);
        bp.setSuspend(0);
        bp.setGroupName(this.breakpointGroup);
        return bp;
    }

    public synchronized MethodBreakpoint getBreakpoint() {
        if (this.methodBreakpoint == null) {
            this.methodBreakpoint = this.createBreakpoint();
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)this.methodBreakpoint);
        }
        return this.methodBreakpoint;
    }

    public void addListener(JPDABreakpointListener listener) {
        this.getBreakpoint().addJPDABreakpointListener(listener);
    }

    public void removeListener(JPDABreakpointListener listener) {
        this.getBreakpoint().removeJPDABreakpointListener(listener);
    }

    public boolean isQualified(MethodBreakpoint mbp) {
        boolean sameGroup = this.breakpointGroup.equals(mbp.getGroupName());
        if (sameGroup) {
            boolean sameClassFilter = Arrays.equals(this.classFilter, mbp.getClassFilters());
            boolean sameMethodName = this.methodName.equals(mbp.getMethodName());
            boolean sameMethodSignature = this.methodSignature.equals(mbp.getMethodSignature());
            if (sameClassFilter && sameMethodName && sameMethodSignature) {
                return true;
            }
        }
        return false;
    }

    public synchronized int purge() {
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        int removedBreakpoints = 0;
        for (Breakpoint bp : debuggerManager.getBreakpoints()) {
            MethodBreakpoint testedBreakpoint;
            if (!(bp instanceof MethodBreakpoint) || !this.isQualified(testedBreakpoint = (MethodBreakpoint)bp)) continue;
            debuggerManager.removeBreakpoint((Breakpoint)testedBreakpoint);
            ++removedBreakpoints;
        }
        this.methodBreakpoint = null;
        return removedBreakpoints;
    }
}

