/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.dash;

import cz.cuni.amis.dash.IEngineDataListener;
import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class EngineData {
    private final PoshPlan plan;
    private final Map<LapPath, List<Long>> storedRecords = new HashMap<LapPath, List<Long>>();
    private final List<IEngineDataListener> listeners = new LinkedList<IEngineDataListener>();

    public EngineData(PoshPlan plan) {
        this.plan = plan;
    }

    public void storePath(LapPath path, long timestamp) {
        List<Long> pathTimestamps = this.storedRecords.get(path);
        if (pathTimestamps == null) {
            pathTimestamps = new LinkedList<Long>();
            this.storedRecords.put(path, pathTimestamps);
            this.notifynewPath(path);
        }
        long lastTimestamp = Long.MIN_VALUE;
        if (!pathTimestamps.isEmpty()) {
            lastTimestamp = pathTimestamps.get(pathTimestamps.size() - 1);
        }
        assert (lastTimestamp <= timestamp);
        pathTimestamps.add(timestamp);
        this.notifyPathReached(path, timestamp);
    }

    public PoshPlan getPlan() {
        return this.plan;
    }

    public Set<LapPath> getPaths() {
        return Collections.unmodifiableSet(this.storedRecords.keySet());
    }

    public List<Long> getOccurrences(LapPath path) {
        if (!this.storedRecords.containsKey(path)) {
            throw new IllegalArgumentException("Path " + path + " hasn never been visites by the engine.");
        }
        return Collections.unmodifiableList(this.storedRecords.get(path));
    }

    void addListener(IEngineDataListener listener) {
        this.listeners.add(listener);
    }

    void removeListener(IEngineDataListener listener) {
        this.listeners.remove(listener);
    }

    private IEngineDataListener[] getListeners() {
        return this.listeners.toArray(new IEngineDataListener[this.listeners.size()]);
    }

    private void notifynewPath(LapPath path) {
        for (IEngineDataListener l : this.getListeners()) {
            l.onNewPath(path);
        }
    }

    private void notifyPathReached(LapPath path, long timestamp) {
        for (IEngineDataListener l : this.getListeners()) {
            l.onPathReached(path, timestamp);
        }
    }
}

