/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.clear2d.utils;

import java.awt.Color;
import java.awt.image.BufferedImage;

public class ColorMulti {
    public static BufferedImage multi(BufferedImage image, Color color) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage result = new BufferedImage(width, height, 6);
        float fColorR = (float)color.getRed() / 255.0f;
        float fColorG = (float)color.getGreen() / 255.0f;
        float fColorB = (float)color.getBlue() / 255.0f;
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                int rgb = image.getRGB(x, y);
                int alpha = rgb >> 24 & 0xFF;
                int red = rgb >> 16 & 0xFF;
                int green = rgb >> 8 & 0xFF;
                int blue = rgb & 0xFF;
                float fRed = (float)red / 255.0f;
                float fGreen = (float)green / 255.0f;
                float fBlue = (float)blue / 255.0f;
                float fResultR = fRed * fColorR;
                float fResultG = fGreen * fColorG;
                float fResultB = fBlue * fColorB;
                red = Math.round(fResultR * 255.0f);
                green = Math.round(fResultG * 255.0f);
                blue = Math.round(fResultB * 255.0f);
                rgb = alpha << 24 | red << 16 | green << 8 | blue;
                result.setRGB(x, y, rgb);
                ++y;
            }
            ++x;
        }
        return result;
    }
}

