/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.clear2d.engine.tween.pos;

import cz.cuni.amis.clear2d.Clear2D;
import cz.cuni.amis.clear2d.engine.iface.ITickable;
import cz.cuni.amis.clear2d.engine.math.Vector2;
import cz.cuni.amis.clear2d.engine.time.C2DTime;
import cz.cuni.amis.clear2d.engine.tween.ITweenFunc;
import cz.cuni.amis.clear2d.engine.tween.TweenEase;
import cz.cuni.amis.clear2d.engine.tween.pos.ITweenPosCallback;
import cz.cuni.amis.clear2d.engine.tween.pos.TweenPosType;

public class TweenPos
implements ITickable {
    private Vector2 from;
    private Vector2 to;
    private Vector2 tweened;
    private TweenPosType tweenType;
    private float tweenValue;
    private ITweenFunc tweenFunc;
    private Vector2 start;
    private Vector2 target;
    private float tweenTime = -1.0f;
    private float c = 0.0f;
    private float cSign = 1.0f;
    private boolean ticking = false;
    public ITweenPosCallback onPlayed;
    public ITweenPosCallback onReversed;

    public TweenPos(Vector2 source, Vector2 target, TweenPosType type, float value, TweenEase ease) {
        this(source, target, type, value, ease.func);
    }

    public TweenPos(Vector2 source, Vector2 target, TweenPosType type, float value, ITweenFunc easeFunc) {
        this.to = new Vector2(target);
        this.tweened = source;
        this.tweenType = type;
        this.tweenValue = value;
        this.tweenFunc = easeFunc;
    }

    private void setTicking(boolean state) {
        if (this.ticking == state) {
            return;
        }
        this.ticking = state;
        if (this.ticking) {
            Clear2D.engine.tickUpdate.add(this);
        } else {
            Clear2D.engine.tickUpdate.remove(this);
        }
    }

    public boolean isTweening() {
        return this.ticking;
    }

    public boolean isPaused() {
        return !this.ticking && this.c > 0.0f && this.c < 1.0f;
    }

    public void play() {
        if (this.from == null) {
            this.from = new Vector2(this.tweened);
        }
        this.start = this.from;
        this.target = this.to;
        this.cSign = 1.0f;
        if (this.tweenTime < 0.0f) {
            this.tweenTime = this.tweenType.type.getTime(this.from, this.to, this.tweenValue);
        }
        this.setTicking(true);
    }

    public void reverse() {
        if (this.from == null) {
            this.from = new Vector2(this.tweened);
        }
        this.start = this.from;
        this.target = this.to;
        this.cSign = -1.0f;
        if (this.tweenTime < 0.0f) {
            this.tweenTime = this.tweenType.type.getTime(this.from, this.to, this.tweenValue);
        }
        this.setTicking(true);
    }

    public void pause() {
        this.setTicking(false);
    }

    public void resume() {
        this.setTicking(true);
    }

    public float getPosition() {
        return this.c;
    }

    public float getTime() {
        return this.c * this.tweenTime;
    }

    @Override
    public void tick(C2DTime time) {
        this.c += this.cSign * time.game.delta / this.tweenTime;
        boolean end = false;
        ITweenPosCallback callback = null;
        if (this.c > 1.0f) {
            this.c = 1.0f;
            end = true;
            callback = this.onPlayed;
        } else if (this.c < 0.0f) {
            this.c = 0.0f;
            end = true;
            callback = this.onReversed;
        }
        this.tweened.assign(this.tweenFunc.getValue(this.start.x, this.target.x, this.c), this.tweenFunc.getValue(this.start.y, this.target.y, this.c));
        if (end) {
            this.setTicking(false);
            this.tweenTime = -1.0f;
            if (callback != null) {
                callback.run(this);
            }
        }
    }
}

