/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.clear2d.engine.tween;

import cz.cuni.amis.clear2d.engine.tween.ITweenFunc;

public enum TweenEase {
    LINEAR(new ITweenFunc(){

        @Override
        public float getValue(float source, float target, float c) {
            return source + (target - source) * c;
        }
    }),
    LINEAR_BACK(new ITweenFunc(){

        @Override
        public float getValue(float source, float target, float c) {
            if ((double)c <= 0.5) {
                return source + (target - source) * c * 2.0f;
            }
            return source + (target - source) * (1.0f - c);
        }
    });

    public final ITweenFunc func;

    private TweenEase(ITweenFunc func) {
        this.func = func;
    }
}

