/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.clear2d.engine.time;

import cz.cuni.amis.clear2d.engine.collections.C2DUpdatables;
import cz.cuni.amis.clear2d.engine.iface.IUpdatable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.LockSupport;

public class C2DTimer
implements Runnable {
    public static final int DELTA_SERIES_BUFFER_SIZE = 30;
    private float fps;
    private float periodSecs;
    private long periodNanos;
    private boolean running = false;
    private Throwable exception;
    private Thread thread;
    private C2DUpdatables<IUpdatable> updates = new C2DUpdatables();
    private long lastNanos;
    private long nextRunNanos;
    private List<Long> deltaSeries = new ArrayList<Long>(30);
    private long deltaSeriesTotal;

    public C2DTimer() {
        this(60.0f, false);
    }

    public C2DTimer(float fps) {
        this(fps, false);
    }

    public C2DTimer(float fps, boolean autostart) {
        this.setFps(fps);
        if (autostart) {
            this.start();
        }
    }

    public float getFps() {
        return this.fps;
    }

    public void setFps(float fps) {
        this.fps = fps;
        this.periodSecs = 1.0f / fps;
        this.periodNanos = (long)(1.0 / (double)fps * 1.0E9);
    }

    public boolean isRunning() {
        return this.running;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void addUpdatable(IUpdatable updatable) {
        this.updates.add(updatable);
    }

    public void removeUpdatable(IUpdatable updatable) {
        this.updates.remove(updatable);
    }

    public boolean containsUpdatable(IUpdatable updatable) {
        return this.updates.contains(updatable);
    }

    @Override
    public void run() {
        this.running = true;
        try {
            try {
                long currNanos = 0L;
                this.lastNanos = System.nanoTime();
                while (this.running) {
                    this.nextRunNanos = this.periodNanos + (long)((double)this.deltaSeriesTotal / 30.0);
                    this.updates.update();
                    while (this.running) {
                        currNanos = System.nanoTime();
                        long deltaNanos = currNanos - this.lastNanos;
                        this.nextRunNanos -= deltaNanos;
                        this.lastNanos = currNanos;
                        if (this.nextRunNanos <= 0L) break;
                        LockSupport.parkNanos(200000L);
                    }
                    if (this.deltaSeries.size() == 30) {
                        this.deltaSeriesTotal -= this.deltaSeries.remove(0).longValue();
                    }
                    this.deltaSeries.add(this.nextRunNanos);
                    this.deltaSeriesTotal += this.nextRunNanos;
                }
            }
            catch (Exception e) {
                this.exception = e;
                e.printStackTrace();
                this.running = false;
                this.thread = null;
            }
        }
        finally {
            this.running = false;
            this.thread = null;
        }
    }

    public synchronized void start() {
        if (this.thread != null) {
            return;
        }
        this.thread = new Thread((Runnable)this, "Clear2D Timer");
        this.thread.start();
        int timeoutCount = 0;
        while (!this.running) {
            Thread.yield();
            if (++timeoutCount <= 10000) continue;
            new RuntimeException("Filed to start C2DTimer! Halting...").printStackTrace();
            System.exit(1);
        }
    }

    public synchronized void stop() {
        if (this.thread != null) {
            this.running = false;
            this.thread.interrupt();
            int timeoutCount = 0;
            while (this.thread != null) {
                Thread.yield();
                if (++timeoutCount <= 10000) continue;
                new RuntimeException("Filed to stop C2DTimer! Halting...").printStackTrace();
                System.exit(1);
            }
        }
    }
}

