/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.clear2d.engine.textures;

import cz.cuni.amis.clear2d.engine.iface.IDrawable;
import java.awt.Graphics2D;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class Texture
implements IDrawable {
    protected Image image;
    protected int width;
    protected int height;

    protected Texture() {
        this.image = null;
    }

    public Texture(File imageFile) {
        if (imageFile == null) {
            throw new RuntimeException("imageFile == null, invalid");
        }
        try {
            this.setImage(ImageIO.read(imageFile));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load image from file: " + imageFile.getAbsolutePath());
        }
    }

    public Texture(InputStream imageInputStream) {
        if (imageInputStream == null) {
            throw new RuntimeException("imageInputStream == null, invalid");
        }
        try {
            this.setImage(ImageIO.read(imageInputStream));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load image from the supplied input stream.");
        }
    }

    public Texture(Image image) {
        this.setImage(image);
    }

    public void setImage(Image image) {
        this.image = image;
        if (this.image == null) {
            this.width = 0;
            this.height = 0;
        } else {
            this.width = image.getWidth(null);
            this.height = image.getHeight(null);
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void drawAt(Graphics2D g, float x, float y) {
        if (this.image == null) {
            return;
        }
        g.drawImage(this.image, (int)x, (int)y, null);
    }
}

