/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.clear2d.engine.textures;

import cz.cuni.amis.clear2d.engine.iface.IDrawable;
import cz.cuni.amis.clear2d.engine.textures.Texture;
import java.awt.Graphics2D;

public class Subtexture
implements IDrawable {
    public String name;
    private Texture texture;
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private int w;
    private int h;

    public Subtexture(Texture texture, int x1, int y1, int x2, int y2) {
        this(null, texture, x1, y1, x2, y2);
    }

    public Subtexture(String name, Texture texture, int x1, int y1, int x2, int y2) {
        this.name = name;
        this.texture = texture;
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.w = x2 - x1;
        this.h = y2 - y1;
    }

    @Override
    public void drawAt(Graphics2D g, float x, float y) {
        if (this.texture == null || this.texture.image == null) {
            return;
        }
        g.drawImage(this.texture.image, (int)x, (int)y, (int)(x + (float)this.w), (int)(y + (float)this.h), this.x1, this.y1, this.x2, this.y2, null);
    }

    public String toString() {
        return "Subtexture[name = " + this.name + ", x1 = " + this.x1 + ", y1 = " + this.y1 + ", x2 = " + this.x2 + ", y2 = " + this.y2 + ", w = " + this.w + ", h = " + this.h + "]";
    }

    @Override
    public int getWidth() {
        return this.w;
    }

    @Override
    public int getHeight() {
        return this.h;
    }
}

