/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.clear2d.engine.prefabs;

import cz.cuni.amis.clear2d.engine.SceneElement;
import cz.cuni.amis.clear2d.engine.components.CText;
import cz.cuni.amis.clear2d.engine.events.Event;
import cz.cuni.amis.clear2d.engine.events.Events;
import cz.cuni.amis.clear2d.engine.fonts.C2DFonts;
import cz.cuni.amis.clear2d.engine.fonts.FontAtlas;
import cz.cuni.amis.clear2d.engine.time.C2DTime;
import java.util.ArrayList;
import java.util.List;

public class FPS
extends SceneElement {
    public CText cText;
    public List<Float> timeDeltas = new ArrayList<Float>();
    public float timeDeltaSum = 0.0f;
    public float fpsWindowSecs = 2.0f;

    static {
        C2DFonts.init();
    }

    public FPS() {
        this(C2DFonts.inconcolata_12px_blue);
    }

    public FPS(FontAtlas font) {
        this.cText = new CText(this, font, "FPS: 0");
    }

    @Override
    public void handleEvent(Event event, Object ... params) {
        if (event == Events.TICK) {
            if (this.fpsWindowSecs <= 0.0f) {
                this.fpsWindowSecs = 1.0f;
            }
            C2DTime time = (C2DTime)params[0];
            float timeDelta = time.real.delta;
            this.timeDeltas.add(Float.valueOf(timeDelta));
            this.timeDeltaSum += timeDelta;
            while (this.timeDeltaSum > this.fpsWindowSecs && this.timeDeltas.size() > 0) {
                float oldTimeDelta = this.timeDeltas.remove(0).floatValue();
                this.timeDeltaSum -= oldTimeDelta;
            }
            if (this.timeDeltas.size() > 0) {
                this.cText.text = String.format("FPS: %.2f", Float.valueOf(1.0f / (this.timeDeltaSum / (float)this.timeDeltas.size())));
            }
        }
    }

    public String toString() {
        return "FPS";
    }
}

