/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.clear2d.engine.math;

public class Vector2 {
    public float x;
    public float y;

    public Vector2() {
        this.x = 0.0f;
        this.y = 0.0f;
    }

    public Vector2(Vector2 source) {
        this.x = source.x;
        this.y = source.y;
    }

    public Vector2(float x, float y) {
        this.assign(x, y);
    }

    public void assign(Vector2 source) {
        this.x = source.x;
        this.y = source.y;
    }

    public void assign(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public float normSq() {
        return this.x * this.x + this.y * this.y;
    }

    public float norm() {
        return (float)Math.sqrt(this.normSq());
    }

    public float length() {
        return this.norm();
    }

    public float dot(Vector2 other) {
        return this.x * other.x + this.y * other.y;
    }

    public float cross(Vector2 other) {
        return this.x * other.y - this.y * other.x;
    }

    public Vector2 inNegate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vector2 inNormalize() {
        float norm = this.norm();
        this.x /= norm;
        this.y /= norm;
        return this;
    }

    public Vector2 inScale(float coef) {
        this.x *= coef;
        this.y *= coef;
        return this;
    }

    public Vector2 inAddX(float x) {
        this.x += x;
        return this;
    }

    public Vector2 inAddY(float y) {
        this.y += y;
        return this;
    }

    public Vector2 inSubX(float x) {
        this.x -= x;
        return this;
    }

    public Vector2 inSubY(float y) {
        this.y -= y;
        return this;
    }

    public Vector2 inMulX(float x) {
        this.x *= x;
        return this;
    }

    public Vector2 inMulY(float y) {
        this.y *= y;
        return this;
    }

    public Vector2 inAdd(float x, float y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public Vector2 inSub(float x, float y) {
        this.x -= x;
        this.y -= y;
        return this;
    }

    public Vector2 inMul(float x, float y) {
        this.x -= x;
        this.y -= y;
        return this;
    }

    public Vector2 inAdd(Vector2 other) {
        this.x += other.x;
        this.y += other.y;
        return this;
    }

    public Vector2 inSub(Vector2 other) {
        this.x -= other.x;
        this.y -= other.y;
        return this;
    }

    public Vector2 inMul(Vector2 other) {
        this.x *= other.x;
        this.y *= other.y;
        return this;
    }

    public Vector2 negate() {
        return new Vector2(-this.x, -this.y);
    }

    public Vector2 normalize() {
        float norm = this.norm();
        return new Vector2(this.x / norm, this.y / norm);
    }

    public Vector2 scale(float coef) {
        return new Vector2(this.x * coef, this.y * coef);
    }

    public Vector2 addX(float x) {
        return new Vector2(this.x + x, this.y);
    }

    public Vector2 addY(float y) {
        return new Vector2(this.x, this.y + y);
    }

    public Vector2 add(float x, float y) {
        return new Vector2(this.x + x, this.y + y);
    }

    public Vector2 sub(float x, float y) {
        return new Vector2(this.x - x, this.y - y);
    }

    public Vector2 mul(float x, float y) {
        return new Vector2(this.x * x, this.y * y);
    }

    public Vector2 add(Vector2 other) {
        return new Vector2(this.x + other.x, this.y + other.y);
    }

    public Vector2 sub(Vector2 other) {
        return new Vector2(this.x - other.x, this.y - other.y);
    }

    public Vector2 mul(Vector2 other) {
        return new Vector2(this.x * other.x, this.y * other.y);
    }

    public String toString() {
        return "Vector2[" + this.x + ", " + this.y + "]";
    }
}

