/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.clear2d.engine.fonts;

import cz.cuni.amis.clear2d.engine.fonts.FontAtlas;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class Font {
    public final String familyName;
    public Map<Integer, Map<Color, FontAtlas>> atlases = new HashMap<Integer, Map<Color, FontAtlas>>();

    public Font(String familyName) {
        this.familyName = familyName;
    }

    public void registerAtlas(int size, Color color, FontAtlas atlas) {
        this.getColors(size, true).put(color, atlas);
    }

    public boolean hasAtlas(int size, Color color) {
        Map<Color, FontAtlas> colors = this.getColors(size);
        if (colors == null) {
            return false;
        }
        return colors.containsKey(color);
    }

    public FontAtlas getAtlas(int size, Color color) {
        Map<Color, FontAtlas> colors = this.getColors(size);
        if (colors == null) {
            return null;
        }
        return colors.get(color);
    }

    protected Map<Color, FontAtlas> getColors(int size) {
        return this.atlases.get(size);
    }

    protected Map<Color, FontAtlas> getColors(int size, boolean autoCreate) {
        Map<Color, FontAtlas> result = this.getColors(size);
        if (result != null) {
            return result;
        }
        result = new HashMap<Color, FontAtlas>();
        this.atlases.put(size, result);
        return result;
    }
}

