/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.clear2d.engine.components;

import cz.cuni.amis.clear2d.engine.Camera;
import cz.cuni.amis.clear2d.engine.SceneElement;
import cz.cuni.amis.clear2d.engine.components.CRender;
import cz.cuni.amis.clear2d.engine.fonts.FontAtlas;
import cz.cuni.amis.clear2d.engine.textures.Subtexture;

public class CText
extends CRender {
    public FontAtlas fontAtlas;
    public String text;
    public int textWidth;
    public int textHeight;

    public CText() {
    }

    public CText(SceneElement owner) {
        super(owner);
    }

    public CText(FontAtlas fontAtlas) {
        this.fontAtlas = fontAtlas;
    }

    public CText(FontAtlas fontAtlas, String text) {
        this.fontAtlas = fontAtlas;
        this.text = text;
        this.updateDimensions();
    }

    public CText(SceneElement owner, FontAtlas fontAtlas) {
        this(owner);
        this.fontAtlas = fontAtlas;
    }

    public CText(SceneElement owner, FontAtlas fontAtlas, String text) {
        this(owner);
        this.fontAtlas = fontAtlas;
        this.text = text;
        this.updateDimensions();
    }

    @Override
    public void render(Camera camera) {
        if (this.text == null || this.text.length() == 0) {
            this.textWidth = 0;
            this.textHeight = 0;
            return;
        }
        if (this.fontAtlas == null) {
            return;
        }
        String[] lines = this.text.split("\n");
        float dX = this.pos.x;
        float dY = this.pos.y;
        float maxWidth = 0.0f;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            int charNum = 0;
            while (charNum < line.length()) {
                char lineChar = line.charAt(charNum);
                Subtexture glyph = this.fontAtlas.getGlyph(lineChar);
                if (glyph != null) {
                    camera.draw(dX, dY, glyph);
                }
                dX += (float)this.fontAtlas.getGlyphWidth();
                ++charNum;
            }
            if (dX - this.pos.x > maxWidth) {
                maxWidth = dX - this.pos.x;
            }
            dX = this.pos.x;
            dY += (float)this.fontAtlas.getGlyphHeight();
            ++n2;
        }
        this.textWidth = (int)maxWidth;
        this.textHeight = (int)(dY - this.pos.y);
    }

    public void updateDimensions() {
        if (this.text == null) {
            this.textWidth = 0;
            this.textHeight = 0;
            return;
        }
        String[] lines = this.text.split("\n");
        int maxWidth = 0;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            int width = this.fontAtlas.getGlyphWidth() * line.length();
            if (width > maxWidth) {
                maxWidth = width;
            }
            ++n2;
        }
        this.textWidth = maxWidth;
        this.textHeight = lines.length * this.fontAtlas.getGlyphHeight();
    }
}

