/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.clear2d.engine.components;

import cz.cuni.amis.clear2d.engine.Camera;
import cz.cuni.amis.clear2d.engine.Component;
import cz.cuni.amis.clear2d.engine.SceneElement;
import cz.cuni.amis.clear2d.engine.events.Event;
import cz.cuni.amis.clear2d.engine.events.Events;
import cz.cuni.amis.clear2d.engine.iface.IDrawable;
import cz.cuni.amis.clear2d.engine.iface.IRenderable;
import cz.cuni.amis.clear2d.engine.iface.ITickable;
import cz.cuni.amis.clear2d.engine.math.Vector2;
import cz.cuni.amis.clear2d.engine.time.C2DTime;

public class CAnimation<TEXTURE extends IDrawable>
extends Component
implements IRenderable,
ITickable {
    public Vector2 pos = new Vector2();
    public TEXTURE[] textures;
    public float fps;
    public int currFrame;
    public float nextFrameSecs;

    public CAnimation() {
    }

    public CAnimation(SceneElement owner) {
        super(owner);
    }

    public void initAnimation(float fps, TEXTURE ... textures) {
        if ((double)fps < 0.001) {
            throw new RuntimeException("Invalid FPS = " + fps);
        }
        this.fps = fps;
        this.textures = textures;
        this.nextFrameSecs = 1.0f / fps;
        this.currFrame = 0;
    }

    @Override
    protected void notifyDo(Event event, Object ... params) {
        if (this.textures == null || this.textures.length <= 0) {
            return;
        }
        if (event == Events.TICK) {
            this.tick((C2DTime)params[0]);
        }
        if (event == Events.RENDER) {
            this.render((Camera)params[0]);
        }
    }

    @Override
    public void render(Camera camera) {
        if (this.currFrame < this.textures.length) {
            camera.draw(this.pos.x, this.pos.y, (IDrawable)this.textures[this.currFrame]);
        }
    }

    @Override
    public void tick(C2DTime time) {
        this.nextFrameSecs -= time.game.delta;
        if (this.nextFrameSecs <= 0.0f) {
            ++this.currFrame;
            this.currFrame %= this.textures.length;
            this.nextFrameSecs += 1.0f / this.fps;
        }
    }
}

