/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.clear2d.engine.collections;

import cz.cuni.amis.clear2d.engine.collections.ConcurrentList;
import cz.cuni.amis.clear2d.engine.iface.ITickable;
import cz.cuni.amis.clear2d.engine.iface.IUpdatable;
import cz.cuni.amis.clear2d.engine.time.C2DTime;

public class C2DTickables<ELEM extends ITickable>
implements IUpdatable {
    private ConcurrentList<ELEM> toAdd = new ConcurrentList();
    private ConcurrentList<ELEM> toRemove = new ConcurrentList();
    private ConcurrentList<ELEM> tickables = new ConcurrentList();
    private C2DTime time;

    public C2DTickables(C2DTime time) {
        this.time = time;
    }

    public void add(ELEM tickable) {
        if (!this.toRemove.remove(tickable)) {
            this.toAdd.add(tickable);
        }
    }

    public boolean contains(ELEM tickable) {
        return this.tickables.contains(tickable) || this.toAdd.contains(tickable);
    }

    public void remove(ELEM tickable) {
        if (!this.toAdd.remove(tickable)) {
            this.toRemove.add(tickable);
        }
    }

    @Override
    public void update() {
        if (this.toRemove.size() > 0) {
            this.tickables.removeAll(this.toRemove);
            this.toRemove.clear();
        }
        if (this.toAdd.size() > 0) {
            this.tickables.addAll(this.toAdd);
            this.toAdd.clear();
        }
        ConcurrentList.ConcurrentIterator iterator = this.tickables.iterator();
        while (iterator.hasNext()) {
            ((ITickable)iterator.next()).tick(this.time);
        }
        iterator.dispose();
    }

    public String toString() {
        return "C2DTickables[#count=" + this.tickables.size() + "]";
    }
}

