package cz.cuni.amis.clear2d.engine.controls;

import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KeyMap {
	
	/**
	 * KEY ("a" or "*") ~ List of {@link KeyEvent#getKeyCode()}s that gives the combination for the KEY.
	 */
	public static final Map<String, List<Integer[]>> keyCodes = new HashMap<String, List<Integer[]>>();
	
	private static void addCombo(String key, Integer... keyCodes) {
		List<Integer[]> alternatives = new ArrayList<Integer[]>(1);
		alternatives.add(keyCodes);		
		KeyMap.keyCodes.put(key, alternatives);
	}
	
	private static void addAlter(String key, Integer... keyCodes) {
		List<Integer[]> alternatives = new ArrayList<Integer[]>(keyCodes.length);
		for (int keyCode : keyCodes) {
			alternatives.add(new Integer[]{keyCode});
		}
		KeyMap.keyCodes.put(key, alternatives);
	}
	
	static {
		
		addAlter("0", KeyEvent.VK_0, KeyEvent.VK_NUMPAD0);
		addAlter("1", KeyEvent.VK_1, KeyEvent.VK_NUMPAD1);
		addAlter("2", KeyEvent.VK_2, KeyEvent.VK_NUMPAD2);
		addAlter("3", KeyEvent.VK_3, KeyEvent.VK_NUMPAD3);
		addAlter("4", KeyEvent.VK_4, KeyEvent.VK_NUMPAD4);
		addAlter("5", KeyEvent.VK_5, KeyEvent.VK_NUMPAD5);
		addAlter("6", KeyEvent.VK_6, KeyEvent.VK_NUMPAD6);
		addAlter("7", KeyEvent.VK_7, KeyEvent.VK_NUMPAD7);
		addAlter("8", KeyEvent.VK_8, KeyEvent.VK_NUMPAD8);
		addAlter("9", KeyEvent.VK_9, KeyEvent.VK_NUMPAD9);
		
		addCombo("a", KeyEvent.VK_A);
		addCombo("b", KeyEvent.VK_B);
		addCombo("c", KeyEvent.VK_C);
		addCombo("d", KeyEvent.VK_D);
		addCombo("e", KeyEvent.VK_E);
		addCombo("f", KeyEvent.VK_F);
		addCombo("g", KeyEvent.VK_G);
		addCombo("h", KeyEvent.VK_H);
		addCombo("i", KeyEvent.VK_I);
		addCombo("j", KeyEvent.VK_J);
		addCombo("k", KeyEvent.VK_K);
		addCombo("l", KeyEvent.VK_L);
		addCombo("m", KeyEvent.VK_M);
		addCombo("n", KeyEvent.VK_N);
		addCombo("o", KeyEvent.VK_O);
		addCombo("p", KeyEvent.VK_P);
		addCombo("q", KeyEvent.VK_Q);
		addCombo("r", KeyEvent.VK_R);
		addCombo("s", KeyEvent.VK_S);
		addCombo("t", KeyEvent.VK_T);
		addCombo("u", KeyEvent.VK_U);
		addCombo("v", KeyEvent.VK_V);
		addCombo("w", KeyEvent.VK_W);
		addCombo("x", KeyEvent.VK_X);
		addCombo("y", KeyEvent.VK_Y);
		addCombo("z", KeyEvent.VK_Z);
		
		addCombo("A", KeyEvent.VK_A, KeyEvent.VK_SHIFT);
		addCombo("B", KeyEvent.VK_B, KeyEvent.VK_SHIFT);
		addCombo("C", KeyEvent.VK_C, KeyEvent.VK_SHIFT);
		addCombo("D", KeyEvent.VK_D, KeyEvent.VK_SHIFT);
		addCombo("E", KeyEvent.VK_E, KeyEvent.VK_SHIFT);
		addCombo("F", KeyEvent.VK_F, KeyEvent.VK_SHIFT);
		addCombo("G", KeyEvent.VK_G, KeyEvent.VK_SHIFT);
		addCombo("H", KeyEvent.VK_H, KeyEvent.VK_SHIFT);
		addCombo("I", KeyEvent.VK_I, KeyEvent.VK_SHIFT);
		addCombo("J", KeyEvent.VK_J, KeyEvent.VK_SHIFT);
		addCombo("K", KeyEvent.VK_K, KeyEvent.VK_SHIFT);
		addCombo("L", KeyEvent.VK_L, KeyEvent.VK_SHIFT);
		addCombo("M", KeyEvent.VK_M, KeyEvent.VK_SHIFT);
		addCombo("N", KeyEvent.VK_N, KeyEvent.VK_SHIFT);
		addCombo("O", KeyEvent.VK_O, KeyEvent.VK_SHIFT);
		addCombo("P", KeyEvent.VK_P, KeyEvent.VK_SHIFT);
		addCombo("Q", KeyEvent.VK_Q, KeyEvent.VK_SHIFT);
		addCombo("R", KeyEvent.VK_R, KeyEvent.VK_SHIFT);
		addCombo("S", KeyEvent.VK_S, KeyEvent.VK_SHIFT);
		addCombo("T", KeyEvent.VK_T, KeyEvent.VK_SHIFT);
		addCombo("U", KeyEvent.VK_U, KeyEvent.VK_SHIFT);
		addCombo("V", KeyEvent.VK_V, KeyEvent.VK_SHIFT);
		addCombo("W", KeyEvent.VK_W, KeyEvent.VK_SHIFT);
		addCombo("X", KeyEvent.VK_X, KeyEvent.VK_SHIFT);
		addCombo("Y", KeyEvent.VK_Y, KeyEvent.VK_SHIFT);
		addCombo("Z", KeyEvent.VK_Z, KeyEvent.VK_SHIFT);
		
		addCombo("+", KeyEvent.VK_PLUS);
		addCombo("-", KeyEvent.VK_MINUS);
		addCombo("*", KeyEvent.VK_MULTIPLY);
		addAlter("/", KeyEvent.VK_DIVIDE, KeyEvent.VK_DIVIDE);
		addCombo(":", KeyEvent.VK_COLON);
		addCombo(";", KeyEvent.VK_SEMICOLON);
		addCombo(",", KeyEvent.VK_COMMA);
		addCombo("\\", KeyEvent.VK_BACK_SLASH);
		addCombo("(", KeyEvent.VK_BRACELEFT);
		addCombo(")", KeyEvent.VK_BRACERIGHT);
		addCombo("[", KeyEvent.VK_OPEN_BRACKET);
		addCombo("]", KeyEvent.VK_CLOSE_BRACKET);
		
		// TODO: add more if required		
	}

}
