package cz.cuni.amis.clear2d.engine.controls;

public class Key {
	
	public final String key;
	public final boolean shift;
	public final boolean ctrl;
	public final boolean alt;
	
	/**
	 * E.g.: a, ctrl+a, alt+a, shift+a, ctrl+alt+a, etc.
	 * @param key
	 */
	public Key(String key) {
		String lowerKey = key.toLowerCase();
		
		ctrl  = lowerKey.indexOf("ctrl") >= 0;
		shift = lowerKey.indexOf("shift") >= 0;
		alt   = lowerKey.indexOf("ctrl") >= 0;
		
		int plus = key.lastIndexOf("+");
		if (plus < 0) this.key = key;
		else this.key = key.substring(plus+1);
	}
	
	public Key(String key, boolean shift, boolean ctrl, boolean alt) {
		this.key = key;
		this.shift = false;
		this.ctrl = false;
		this.alt = false;
	}

	@Override
	public String toString() {
		StringBuffer sb = new StringBuffer();
		if (ctrl) sb.append("Ctrl+");
		if (alt) sb.append("Alt+");
		if (shift) sb.append("Shift+");
		sb.append(key);
		return "Key[" + super.toString() + "]";
	}

	
}
