/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.clear2d.utils;

import cz.cuni.amis.clear2d.engine.textures.TextureAtlasXML;
import cz.cuni.amis.clear2d.utils.Sanitize;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class TextureAtlasToEnum {
    public static void transform(File textureAtlasXMLFile, File targetEnumFile) {
        FileOutputStream out;
        TextureAtlasXML atlas = TextureAtlasXML.loadXML(textureAtlasXMLFile);
        try {
            out = new FileOutputStream(targetEnumFile);
        }
        catch (FileNotFoundException e1) {
            throw new RuntimeException("Failed to open for writing: " + targetEnumFile.getAbsolutePath());
        }
        PrintWriter writer = new PrintWriter(out);
        writer.println("public enum TextureAtlasEnum {");
        writer.println();
        boolean first = true;
        for (TextureAtlasXML.SubtextureXML subtexture : atlas.subtextures) {
            writer.print("  ");
            if (first) {
                first = false;
            } else {
                writer.print(",");
            }
            String name = Sanitize.variablify(subtexture.name);
            writer.print(name);
            writer.print("(\"");
            writer.print(subtexture.name);
            writer.println("\")");
        }
        writer.println("  ;");
        writer.println();
        writer.println("  public final String texture;");
        writer.println();
        writer.println("  private TextureAtlasEnum(String name) {");
        writer.println("    texture = name;");
        writer.println("  }");
        writer.println();
        writer.println("}");
        try {
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        File source = new File("d:/Workspaces/MFF/NAIL069-UI1/Minesweeper/GIT/Minesweeper4J/src/main/resources/cz/minesweeper4j/ui/atlas/sprites.xml");
        File target = new File("d:/Workspaces/MFF/NAIL069-UI1/Minesweeper/GIT/Minesweeper4J/src/main/java/cz/minesweeper4j/ui/TextureAtlasEnum.java");
        TextureAtlasToEnum.transform(source, target);
        System.out.println("---/// DONE ///---");
    }
}

